/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Section;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.TransitSectionAction;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransitManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransitManagerXml.class);

    @Override
    public Element store(Object o) {
        Element transits = new Element("transits");
        this.setStoreElementClass(transits);
        TransitManager tm = (TransitManager)o;
        if (tm != null) {
            SortedSet tstList = tm.getNamedBeanSet();
            if (tstList.isEmpty()) {
                return null;
            }
            for (Transit transit : tstList) {
                ArrayList<TransitSection> tsList;
                String tstName = transit.getSystemName();
                log.debug("Transit system name is {}", (Object)tstName);
                if (transit.getTransitType() == Transit.TransitType.DYNAMICADHOC) continue;
                Element elem = new Element("transit");
                elem.addContent((Content)new Element("systemName").addContent(tstName));
                elem.setAttribute("systemName", tstName);
                String uName = transit.getUserName();
                if (uName != null && !uName.isEmpty()) {
                    elem.setAttribute("userName", uName);
                }
                if ((tsList = transit.getTransitSectionList()).isEmpty()) {
                    log.warn("Not Storing Transit \"{}\" as it has no TransitSections", (Object)transit.getDisplayName());
                    continue;
                }
                this.storeCommon(transit, elem);
                for (TransitSection ts : tsList) {
                    if (ts == null || ts.isTemporary()) continue;
                    Element tsElem = new Element("transitsection");
                    Section tSection = ts.getSection();
                    if (tSection != null) {
                        tsElem.setAttribute("sectionname", tSection.getSystemName());
                    } else {
                        tsElem.setAttribute("sectionname", "null");
                    }
                    tsElem.setAttribute("sequence", Integer.toString(ts.getSequenceNumber()));
                    tsElem.setAttribute("direction", Integer.toString(ts.getDirection()));
                    tsElem.setAttribute("alternate", ts.isAlternate() ? "yes" : "no");
                    tsElem.setAttribute("safe", ts.isSafe() ? "yes" : "no");
                    tsElem.setAttribute("stopallocatingsensor", ts.getStopAllocatingSensor());
                    ArrayList<TransitSectionAction> tsaList = ts.getTransitSectionActionList();
                    if (!tsaList.isEmpty()) {
                        for (TransitSectionAction tsa : tsaList) {
                            if (tsa == null) continue;
                            Element tsaElem = new Element("transitsectionaction");
                            tsaElem.setAttribute("whencode", Integer.toString(tsa.getWhenCode()));
                            tsaElem.setAttribute("whatcode", Integer.toString(tsa.getWhatCode()));
                            tsaElem.setAttribute("whendata", Integer.toString(tsa.getDataWhen()));
                            tsaElem.setAttribute("whenstring", tsa.getStringWhen());
                            tsaElem.setAttribute("whatdata1", Integer.toString(tsa.getDataWhat1()));
                            tsaElem.setAttribute("whatdata2", Integer.toString(tsa.getDataWhat2()));
                            tsaElem.setAttribute("whatstring", tsa.getStringWhat());
                            tsaElem.setAttribute("whatstring2", tsa.getStringWhat2());
                            tsElem.addContent((Content)tsaElem);
                        }
                    }
                    elem.addContent((Content)tsElem);
                }
                transits.addContent((Content)elem);
            }
        }
        return transits;
    }

    public void setStoreElementClass(Element transits) {
        transits.setAttribute("class", "jmri.configurexml.TransitManagerXml");
    }

    @Override
    public boolean load(Element sharedTransits, Element perNodeTransits) {
        this.loadTransits(sharedTransits, perNodeTransits);
        return true;
    }

    public void loadTransits(Element sharedTransits, Element perNodeTransits) {
        List transitList = sharedTransits.getChildren("transit");
        log.debug("Found {} transits", (Object)transitList.size());
        TransitManager tm = InstanceManager.getDefault(TransitManager.class);
        tm.setPropertyChangesSilenced("beans", true);
        for (Element tst : transitList) {
            Transit x;
            String sysName = this.getSystemName(tst);
            String userName = this.getUserName(tst);
            try {
                x = tm.createNewTransit(sysName, userName);
            }
            catch (IllegalArgumentException ex) {
                log.error("Continuing following Exception: ", (Throwable)ex);
                continue;
            }
            this.loadCommon(x, tst);
            List transitTransitSectionList = tst.getChildren("transitsection");
            for (Element elem : transitTransitSectionList) {
                int seq = 0;
                int dir = 1;
                boolean alt = false;
                boolean safe = false;
                String sectionName = elem.getAttribute("sectionname").getValue();
                if (sectionName.equals("null")) {
                    log.warn("When loading configuration - missing Section in Transit {}", (Object)sysName);
                }
                try {
                    seq = elem.getAttribute("sequence").getIntValue();
                    dir = elem.getAttribute("direction").getIntValue();
                }
                catch (DataConversionException e) {
                    log.error("Data Conversion Exception when loading direction of entry point - ", (Throwable)e);
                }
                if (elem.getAttribute("alternate").getValue().equals("yes")) {
                    alt = true;
                }
                if (elem.getAttribute("safe") != null && elem.getAttribute("safe").getValue().equals("yes")) {
                    safe = true;
                }
                String stopAllocatingSensor = "";
                if (elem.getAttribute("stopallocatingsensor") != null && (stopAllocatingSensor = elem.getAttribute("stopallocatingsensor").getValue()).equals("null")) {
                    log.warn("When loading configuration - missing Section in Transit {}", (Object)sysName);
                    stopAllocatingSensor = "";
                }
                TransitSection ts = new TransitSection(sectionName, seq, dir, alt, safe, stopAllocatingSensor);
                x.addTransitSection(ts);
                List transitTransitSectionActionList = elem.getChildren("transitsectionaction");
                for (Element elemx : transitTransitSectionActionList) {
                    int tWhen = 1;
                    int tWhat = 1;
                    int tWhenData = 0;
                    String tWhenString = elemx.getAttribute("whenstring").getValue();
                    int tWhatData1 = 0;
                    int tWhatData2 = 0;
                    String tWhatString = elemx.getAttribute("whatstring").getValue();
                    String tWhatString2 = "";
                    if (elemx.getAttribute("whatstring2") != null) {
                        tWhatString2 = elemx.getAttribute("whatstring2").getValue();
                    }
                    try {
                        tWhen = elemx.getAttribute("whencode").getIntValue();
                        tWhat = elemx.getAttribute("whatcode").getIntValue();
                        tWhenData = elemx.getAttribute("whendata").getIntValue();
                        tWhatData1 = elemx.getAttribute("whatdata1").getIntValue();
                        tWhatData2 = elemx.getAttribute("whatdata2").getIntValue();
                    }
                    catch (DataConversionException e) {
                        log.error("Data Conversion Exception when loading transit section action - ", (Throwable)e);
                    }
                    TransitSectionAction tsa = new TransitSectionAction(tWhen, tWhat, tWhenData, tWhatData1, tWhatData2, tWhenString, tWhatString, tWhatString2);
                    ts.addAction(tsa);
                }
            }
        }
        tm.setPropertyChangesSilenced("beans", false);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(TransitManager.class).getXMLOrder();
    }
}

