/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SortOrder;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.swing.JmriJTablePersistenceManager;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserMessagePreferencesXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserMessagePreferencesXml.class);

    @Override
    public Element store(Object o) {
        return null;
    }

    public void setStoreElementClass(Element messages) {
        messages.setAttribute("class", "jmri.managers.configurexml.DefaultUserMessagePreferencesXml");
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String strClass;
        UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
        p.setLoading();
        List settingList = shared.getChildren("setting");
        for (Object set : settingList) {
            String name = set.getText();
            p.setSimplePreferenceState(name, true);
        }
        List comboList = shared.getChildren("comboBoxLastValue");
        for (Object cmb : comboList) {
            List comboItem = cmb.getChildren("comboBox");
            for (int x = 0; x < comboItem.size(); ++x) {
                String combo = ((Element)comboItem.get(x)).getAttribute("name").getValue();
                String setting = ((Element)comboItem.get(x)).getAttribute("lastSelected").getValue();
                p.setComboBoxLastSelection(combo, setting);
            }
        }
        List classList = shared.getChildren("classPreferences");
        for (Object cls : classList) {
            List multipleList = cls.getChildren("multipleChoice");
            strClass = cls.getAttribute("class").getValue();
            for (Element mul : multipleList) {
                List multiItem = mul.getChildren("option");
                for (Object muli : multiItem) {
                    String item = muli.getAttribute("item").getValue();
                    int value = 0;
                    try {
                        value = muli.getAttribute("value").getIntValue();
                    }
                    catch (DataConversionException e) {
                        log.error("failed to convert positional attribute");
                    }
                    p.setMultipleChoiceOption(strClass, item, value);
                }
            }
            List preferenceList = cls.getChildren("reminderPrompts");
            for (Element pref : preferenceList) {
                Object muli;
                List reminderBoxes = pref.getChildren("reminder");
                muli = reminderBoxes.iterator();
                while (muli.hasNext()) {
                    Element rem = (Element)muli.next();
                    String name = rem.getText();
                    p.setPreferenceState(strClass, name, true);
                }
            }
        }
        List windowList = shared.getChildren("windowDetails");
        for (Element win : windowList) {
            strClass = win.getAttribute("class").getValue();
            p.setWindowLocation(strClass, new Point(this.extractCoord(win, "locX"), this.extractCoord(win, "locY")));
            p.setWindowSize(strClass, new Dimension(this.extractCoord(win, "width"), this.extractCoord(win, "height")));
            Element prop = win.getChild("properties");
            if (prop == null) continue;
            for (Object next : prop.getChildren("property")) {
                Element e = (Element)next;
                try {
                    String key = e.getChild("key").getText();
                    Object value = null;
                    if (e.getChild("value") != null) {
                        Class<?> cl = Class.forName(e.getChild("value").getAttributeValue("class"));
                        Constructor<?> ctor = cl.getConstructor(String.class);
                        value = ctor.newInstance(e.getChild("value").getText());
                    }
                    p.setProperty(strClass, key, value);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    log.error("Error loading properties", (Throwable)ex);
                }
            }
        }
        List tablesList = shared.getChildren("tableDetails");
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(jtpm -> {
            for (Element tables : tablesList) {
                List tableList = tables.getChildren("table");
                for (Element table : tableList) {
                    String strTableName = table.getAttribute("name").getValue();
                    if (jtpm.isPersistenceDataRetained(strTableName)) continue;
                    List columnList = table.getChildren("column");
                    for (Element column : columnList) {
                        String strColumnName = column.getAttribute("name").getValue();
                        int order = -1;
                        int width = -1;
                        SortOrder sort = SortOrder.UNSORTED;
                        boolean hidden = false;
                        if (column.getChild("order") != null) {
                            order = Integer.parseInt(column.getChild("order").getText());
                        }
                        if (column.getChild("width") != null) {
                            width = Integer.parseInt(column.getChild("width").getText());
                        }
                        if (column.getChild("sortOrder") != null) {
                            sort = SortOrder.valueOf(column.getChild("sortOrder").getText());
                        } else if (column.getChild("sort") != null) {
                            switch (Integer.parseInt(column.getChild("sort").getText())) {
                                case 1: {
                                    sort = SortOrder.ASCENDING;
                                    break;
                                }
                                case -1: {
                                    sort = SortOrder.DESCENDING;
                                    break;
                                }
                            }
                        }
                        if (column.getChild("hidden") != null && column.getChild("hidden").getText().equals("yes")) {
                            hidden = true;
                        }
                        this.setTableColumnPreferences((JmriJTablePersistenceManager)jtpm, strTableName, strColumnName, order, width, sort, hidden);
                    }
                }
            }
        });
        p.finishLoading();
        return true;
    }

    private int extractCoord(Element win, String name) {
        List locList = win.getChildren(name);
        double coord = 0.0;
        for (Element loc : locList) {
            try {
                coord = Double.parseDouble(loc.getText());
            }
            catch (NumberFormatException e) {
                log.error("failed to convert positional attribute");
            }
        }
        return (int)coord;
    }

    private void setTableColumnPreferences(JmriJTablePersistenceManager jtpm, String table, String column, int order, int width, SortOrder sort, boolean hidden) {
    }
}

