/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.managers.ManagerDefaultSelector;
import jmri.profile.ProfileManager;
import org.jdom2.Content;
import org.jdom2.Element;

public class ManagerDefaultSelectorXml
extends AbstractXmlAdapter {
    @Override
    public Element store(Object o) {
        Element e = new Element("managerdefaults");
        e.setAttribute("class", this.getClass().getName());
        for (Class<?> c : InstanceManager.getDefault(ManagerDefaultSelector.class).defaults.keySet()) {
            String n = InstanceManager.getDefault(ManagerDefaultSelector.class).defaults.get(c);
            Element p = new Element("setting");
            Element key = new Element("key");
            key.addContent(c.getName());
            Element value = new Element("value");
            value.addContent(n);
            p.addContent((Content)key);
            p.addContent((Content)value);
            e.addContent((Content)p);
        }
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List list = shared.getChildren("setting");
        for (Element s : list) {
            String name = s.getChild("value").getText();
            String className = s.getChild("key").getText();
            Class<?> c = null;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                continue;
            }
            InstanceManager.getDefault(ManagerDefaultSelector.class).setDefault(c, name);
        }
        InstanceManager.getDefault(ManagerDefaultSelector.class).configure(ProfileManager.getDefault().getActiveProfile());
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.registerPref(InstanceManager.getDefault(ManagerDefaultSelector.class)));
        return true;
    }
}

