/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.profile.Bundle;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddProfileDialog
extends JDialog {
    private String profileId;
    private boolean setNextProfile = false;
    private Profile source = null;
    private JButton btnBrowse;
    private JButton btnCancel;
    private JButton btnOk;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblProfileFolder;
    private JLabel lblProfileLocation;
    private JLabel lblProfileName;
    private JLabel lblProfileNameAndLocation;
    private JTextField profileFolder;
    private JTextField profileLocation;
    private JTextField profileName;
    private static final Logger log = LoggerFactory.getLogger(AddProfileDialog.class);

    public AddProfileDialog(Frame parent, boolean modal, boolean setNextProfile) {
        super(parent, modal);
        this.setNextProfile = setNextProfile;
        this.initComponents();
    }

    AddProfileDialog(Dialog parent, boolean modal, boolean setNextProfile) {
        super(parent, modal);
        this.setNextProfile = setNextProfile;
        this.initComponents();
    }

    private void initComponents() {
        this.lblProfileNameAndLocation = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.profileName = new JTextField();
        this.lblProfileName = new JLabel();
        this.lblProfileLocation = new JLabel();
        this.profileLocation = new JTextField();
        this.profileFolder = new JTextField();
        this.btnBrowse = new JButton();
        this.lblProfileFolder = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("jmri/profile/Bundle");
        this.setTitle(bundle.getString("AddProfileDialog.title"));
        this.setMinimumSize(new Dimension(413, 239));
        this.lblProfileNameAndLocation.setFont(this.lblProfileNameAndLocation.getFont().deriveFont(this.lblProfileNameAndLocation.getFont().getStyle() | 1));
        this.lblProfileNameAndLocation.setText(bundle.getString("AddProfileDialog.lblProfileNameAndLocation.text"));
        this.profileName.setText("");
        this.profileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddProfileDialog.this.profileNameActionPerformed(null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddProfileDialog.this.profileNameActionPerformed(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddProfileDialog.this.profileNameActionPerformed(null);
            }
        });
        this.profileName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AddProfileDialog.this.profileNameFocusLost(evt);
            }
        });
        this.profileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.profileNameActionPerformed(evt);
            }
        });
        this.profileName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AddProfileDialog.this.profileNameKeyTyped(evt);
            }
        });
        this.lblProfileName.setText(bundle.getString("AddProfileDialog.lblProfileName.text"));
        this.lblProfileLocation.setText(bundle.getString("AddProfileDialog.lblProfileLocation.text"));
        this.profileLocation.setText(ProfileManager.getDefault().getDefaultSearchPath().getPath());
        this.profileLocation.setMinimumSize(new Dimension(14, 128));
        this.profileLocation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AddProfileDialog.this.profileLocationFocusLost(evt);
            }
        });
        this.profileLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.profileLocationActionPerformed(evt);
            }
        });
        this.profileLocation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AddProfileDialog.this.profileLocationKeyTyped(evt);
            }
        });
        this.profileFolder.setEditable(false);
        this.profileFolder.setText(ProfileManager.getDefault().getDefaultSearchPath().getPath());
        this.profileFolder.setEnabled(false);
        this.profileFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.profileFolderActionPerformed(evt);
            }
        });
        this.btnBrowse.setText(bundle.getString("AddProfileDialog.btnBrowse.text"));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.btnBrowseActionPerformed(evt);
            }
        });
        this.lblProfileFolder.setText(bundle.getString("AddProfileDialog.lblProfileFolder.text"));
        this.btnCancel.setText(bundle.getString("AddProfileDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOk.setText(bundle.getString("AddProfileDialog.btnOk.text"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddProfileDialog.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblProfileName).addGap(24, 24, 24).addComponent(this.profileName, -1, 185, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProfileLocation).addComponent(this.lblProfileFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.profileFolder).addComponent(this.profileLocation, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse)).addGroup(layout.createSequentialGroup().addComponent(this.lblProfileNameAndLocation).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblProfileNameAndLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileName, -2, -1, -2).addComponent(this.lblProfileName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileLocation, -2, -1, -2).addComponent(this.btnBrowse).addComponent(this.lblProfileLocation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileFolder, -2, -1, -2).addComponent(this.lblProfileFolder)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void profileNameActionPerformed(ActionEvent evt) {
        Object location = this.profileLocation.getText();
        this.profileId = FileUtil.sanitizeFilename(this.profileName.getText());
        if (this.profileId.isEmpty()) {
            this.profileFolder.setText((String)location);
        } else {
            if (!((String)location).endsWith(File.separator)) {
                location = (String)location + File.separator;
            }
            this.profileFolder.setText((String)location + this.profileId + ".jmri");
        }
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        JmriJFileChooser chooser = new JmriJFileChooser(this.profileLocation.getText());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            try {
                this.profileLocation.setText(chooser.getSelectedFile().getCanonicalPath());
                this.profileNameActionPerformed(evt);
            }
            catch (IOException ex) {
                log.error("Error selecting profile location", (Throwable)ex);
            }
        }
    }

    private void profileFolderActionPerformed(ActionEvent evt) {
        this.profileNameActionPerformed(evt);
    }

    private void profileLocationActionPerformed(ActionEvent evt) {
        this.profileNameActionPerformed(evt);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Profile p = new Profile(this.profileName.getText(), this.profileId, new File(this.profileFolder.getText()));
            ProfileManager.getDefault().addProfile(p);
            if (this.source != null) {
                ProfileUtils.copy(this.source, p);
            }
            if (this.setNextProfile) {
                ProfileManager.getDefault().setNextActiveProfile(p);
            } else {
                ProfileManager.getDefault().setActiveProfile(p);
            }
            ProfileManager.getDefault().saveActiveProfile(p, ProfileManager.getDefault().isAutoStartActiveProfile());
            if (this.source != null) {
                log.info("Created profile \"{}\" by copying profile \"{}\"", (Object)p.getName(), (Object)this.source.getName());
            } else {
                log.info("Created new profile \"{}\"", (Object)p.getName());
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.dispose();
        }
        catch (IOException | IllegalArgumentException ex) {
            this.setCursor(Cursor.getDefaultCursor());
            JmriJOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), "Error Creating Profile", 0);
            log.error("Error saving profile", (Throwable)ex);
        }
    }

    private void profileNameKeyTyped(KeyEvent evt) {
        this.profileNameActionPerformed(null);
    }

    private void profileNameFocusLost(FocusEvent evt) {
        this.profileNameActionPerformed(null);
    }

    private void profileLocationKeyTyped(KeyEvent evt) {
        this.profileNameActionPerformed(null);
    }

    private void profileLocationFocusLost(FocusEvent evt) {
        this.profileNameActionPerformed(null);
    }

    void setSourceProfile(Profile profile) {
        this.source = profile;
        this.setTitle(Bundle.getMessage("AddProfileDialog.copyTitle"));
    }
}

