/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.roster.Roster;
import jmri.profile.AddProfileDialog;
import jmri.profile.Bundle;
import jmri.profile.Profile;
import jmri.profile.ProfileFileFilter;
import jmri.profile.ProfileFileView;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileTableModel;
import jmri.profile.SearchPathTableModel;
import jmri.swing.PreferencesPanel;
import jmri.util.FileUtil;
import jmri.util.prefs.InitializationException;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfilePreferencesPanel
extends JPanel
implements PreferencesPanel {
    private JButton btnActivateProfile;
    private JButton btnAddSearchPath;
    private JButton btnCopyProfile;
    private JButton btnCreateNewProfile;
    private JButton btnDeleteProfile;
    private JButton btnExportProfile;
    private JButton btnOpenExistingProfile;
    private JButton btnRemoveSearchPath;
    private JMenuItem copyMI;
    private JMenuItem deleteMI;
    private JPanel enabledPanel;
    private ButtonGroup grpStartWithSelectors;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JPopupMenu profilesPopupMenu;
    private JTable profilesTbl;
    private JRadioButton rdoStartWithActiveProfile;
    private JRadioButton rdoStartWithProfileSelector;
    private JMenuItem renameMI;
    private JPanel searchPathsPanel;
    private JTable searchPathsTbl;
    private JSpinner spinnerTimeout;
    private static final Logger log = LoggerFactory.getLogger(ProfilePreferencesPanel.class);

    public ProfilePreferencesPanel() {
        this.initComponents();
        this.spinnerTimeout.setValue(ProfileManager.getDefault().getAutoStartActiveProfileTimeout());
        this.profilesTblValueChanged(null);
        this.searchPathsTblValueChanged(null);
        int index = ProfileManager.getDefault().getAllProfiles().indexOf(ProfileManager.getDefault().getActiveProfile());
        if (index != -1) {
            this.profilesTbl.setRowSelectionInterval(index, index);
        }
    }

    private void initComponents() {
        this.profilesPopupMenu = new JPopupMenu();
        this.renameMI = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.copyMI = new JMenuItem();
        this.deleteMI = new JMenuItem();
        this.grpStartWithSelectors = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.enabledPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.profilesTbl = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                try {
                    return this.getValueAt(this.rowAtPoint(e.getPoint()), -1).toString();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
        };
        this.btnOpenExistingProfile = new JButton();
        this.btnDeleteProfile = new JButton();
        this.btnCreateNewProfile = new JButton();
        this.btnActivateProfile = new JButton();
        this.btnExportProfile = new JButton();
        this.btnCopyProfile = new JButton();
        this.spinnerTimeout = new JSpinner();
        this.jLabel1 = new JLabel();
        this.rdoStartWithActiveProfile = new JRadioButton();
        this.rdoStartWithProfileSelector = new JRadioButton();
        this.searchPathsPanel = new JPanel();
        this.btnRemoveSearchPath = new JButton();
        this.btnAddSearchPath = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.searchPathsTbl = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                try {
                    return this.getValueAt(this.rowAtPoint(e.getPoint()), -1).toString();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
        };
        this.profilesPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ProfilePreferencesPanel.this.profilesPopupMenuPopupMenuWillBecomeVisible(evt);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("jmri/profile/Bundle");
        this.renameMI.setText(bundle.getString("ProfilePreferencesPanel.renameMI.text"));
        this.renameMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.renameMIActionPerformed(evt);
            }
        });
        this.profilesPopupMenu.add(this.renameMI);
        this.profilesPopupMenu.add(this.jSeparator1);
        this.copyMI.setText(bundle.getString("ProfilePreferencesPanel.copyMI.text"));
        this.profilesPopupMenu.add(this.copyMI);
        this.deleteMI.setText(bundle.getString("ProfilePreferencesPanel.deleteMI.text"));
        this.profilesPopupMenu.add(this.deleteMI);
        if (ProfileManager.getDefault().isAutoStartActiveProfile()) {
            this.rdoStartWithActiveProfile.setSelected(true);
        } else {
            this.rdoStartWithProfileSelector.setSelected(true);
        }
        this.profilesTbl.setModel(new ProfileTableModel());
        this.profilesTbl.getSelectionModel().addListSelectionListener(new ProfilesSelectionListener());
        this.profilesTbl.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.profilesTbl);
        this.btnOpenExistingProfile.setText(bundle.getString("ProfilePreferencesPanel.btnOpenExistingProfile.text"));
        this.btnOpenExistingProfile.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnOpenExistingProfile.toolTipText"));
        this.btnOpenExistingProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnOpenExistingProfileActionPerformed(evt);
            }
        });
        this.btnDeleteProfile.setText(bundle.getString("ProfilePreferencesPanel.btnDeleteProfile.text"));
        this.btnDeleteProfile.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnDeleteProfile.toolTipText"));
        this.btnDeleteProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnDeleteProfileActionPerformed(evt);
            }
        });
        this.btnCreateNewProfile.setText(bundle.getString("ProfilePreferencesPanel.btnCreateNewProfile.text"));
        this.btnCreateNewProfile.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnCreateNewProfile.toolTipText"));
        this.btnCreateNewProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnCreateNewProfileActionPerformed(evt);
            }
        });
        this.btnActivateProfile.setText(bundle.getString("ProfilePreferencesPanel.btnActivateProfile.text"));
        this.btnActivateProfile.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnActivateProfile.toolTipText"));
        this.btnActivateProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnActivateProfileActionPerformed(evt);
            }
        });
        this.btnExportProfile.setText(bundle.getString("ProfilePreferencesPanel.btnExportProfile.text"));
        this.btnExportProfile.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnExportProfile.toolTipText"));
        this.btnExportProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnExportProfileActionPerformed(evt);
            }
        });
        this.btnCopyProfile.setText(bundle.getString("ProfilePreferencesPanel.btnCopyProfile.text"));
        this.btnCopyProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnCopyProfileActionPerformed(evt);
            }
        });
        this.spinnerTimeout.setModel(new SpinnerNumberModel(10, 0, 500, 1));
        this.spinnerTimeout.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProfilePreferencesPanel.this.spinnerTimeoutStateChanged(evt);
            }
        });
        this.jLabel1.setText(bundle.getString("ProfilePreferencesPanel.jLabel1.text"));
        this.grpStartWithSelectors.add(this.rdoStartWithActiveProfile);
        this.rdoStartWithActiveProfile.setText(bundle.getString("ProfilePreferencesPanel.rdoStartWithActiveProfile.text"));
        this.rdoStartWithActiveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.rdoStartWithActiveProfileActionPerformed(evt);
            }
        });
        this.grpStartWithSelectors.add(this.rdoStartWithProfileSelector);
        this.rdoStartWithProfileSelector.setText(bundle.getString("ProfilePreferencesPanel.rdoStartWithProfileSelector.text"));
        this.rdoStartWithProfileSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.rdoStartWithProfileSelectorActionPerformed(evt);
            }
        });
        GroupLayout enabledPanelLayout = new GroupLayout(this.enabledPanel);
        this.enabledPanel.setLayout(enabledPanelLayout);
        enabledPanelLayout.setHorizontalGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enabledPanelLayout.createSequentialGroup().addContainerGap().addGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(enabledPanelLayout.createSequentialGroup().addComponent(this.btnActivateProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenExistingProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreateNewProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCopyProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExportProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 60, Short.MAX_VALUE).addComponent(this.btnDeleteProfile)).addGroup(enabledPanelLayout.createSequentialGroup().addGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rdoStartWithActiveProfile).addGroup(enabledPanelLayout.createSequentialGroup().addComponent(this.rdoStartWithProfileSelector).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerTimeout, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        enabledPanelLayout.setVerticalGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enabledPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpenExistingProfile).addComponent(this.btnCreateNewProfile).addComponent(this.btnActivateProfile).addComponent(this.btnExportProfile).addComponent(this.btnDeleteProfile).addComponent(this.btnCopyProfile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdoStartWithActiveProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(enabledPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdoStartWithProfileSelector).addComponent(this.spinnerTimeout, -2, -1, -2).addComponent(this.jLabel1))));
        this.jTabbedPane1.addTab(bundle.getString("ProfilePreferencesPanel.enabledPanel.TabConstraints.tabTitle"), this.enabledPanel);
        this.btnRemoveSearchPath.setText(bundle.getString("ProfilePreferencesPanel.btnRemoveSearchPath.text"));
        this.btnRemoveSearchPath.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnRemoveSearchPath.toolTipText"));
        this.btnRemoveSearchPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnRemoveSearchPathActionPerformed(evt);
            }
        });
        this.btnAddSearchPath.setText(bundle.getString("ProfilePreferencesPanel.btnAddSearchPath.text"));
        this.btnAddSearchPath.setToolTipText(bundle.getString("ProfilePreferencesPanel.btnAddSearchPath.toolTipText"));
        this.btnAddSearchPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePreferencesPanel.this.btnAddSearchPathActionPerformed(evt);
            }
        });
        this.searchPathsTbl.setModel(new SearchPathTableModel());
        this.searchPathsTbl.getSelectionModel().addListSelectionListener(new SearchPathSelectionListener());
        this.searchPathsTbl.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane3.setViewportView(this.searchPathsTbl);
        GroupLayout searchPathsPanelLayout = new GroupLayout(this.searchPathsPanel);
        this.searchPathsPanel.setLayout(searchPathsPanelLayout);
        searchPathsPanelLayout.setHorizontalGroup(searchPathsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPathsPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPathsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 667, Short.MAX_VALUE).addGroup(searchPathsPanelLayout.createSequentialGroup().addComponent(this.btnAddSearchPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRemoveSearchPath))).addContainerGap()));
        searchPathsPanelLayout.setVerticalGroup(searchPathsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPathsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPathsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddSearchPath).addComponent(this.btnRemoveSearchPath)).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("ProfilePreferencesPanel.searchPathsPanel.TabConstraints.tabTitle_1"), this.searchPathsPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(bundle.getString("ProfilePreferencesPanel.enabledPanel.TabConstraints.tabTitle"));
    }

    private void renameMIActionPerformed(ActionEvent evt) {
    }

    private void profilesPopupMenuPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.profilesTbl.getSelectedRowCount() == 1) {
            this.renameMI.setEnabled(true);
        }
    }

    private void btnAddSearchPathActionPerformed(ActionEvent evt) {
        JmriJFileChooser chooser = new JmriJFileChooser(FileUtil.getHomePath());
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new ProfileFileFilter());
        chooser.setFileView(new ProfileFileView());
        if (chooser.showOpenDialog(this) == 0) {
            try {
                ProfileManager.getDefault().addSearchPath(chooser.getSelectedFile());
                int index = ProfileManager.getDefault().getAllSearchPaths().indexOf(chooser.getSelectedFile());
                this.searchPathsTbl.setRowSelectionInterval(index, index);
            }
            catch (IOException ex) {
                log.warn("Unable to write profiles while adding search path {}", (Object)chooser.getSelectedFile().getPath(), (Object)ex);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnAddSearchPath.errorMessage", chooser.getSelectedFile().getPath(), ex.getLocalizedMessage()), Bundle.getMessage("ProfilePreferencesPanel.btnAddSearchPath.errorTitle"), 0);
            }
        }
    }

    private void btnRemoveSearchPathActionPerformed(ActionEvent evt) {
        ArrayList<File> paths = new ArrayList<File>(this.searchPathsTbl.getSelectedRowCount());
        for (int row : this.searchPathsTbl.getSelectedRows()) {
            paths.add(ProfileManager.getDefault().getSearchPaths(row));
        }
        Object object = paths.iterator();
        while (object.hasNext()) {
            File path = (File)object.next();
            try {
                ProfileManager.getDefault().removeSearchPath(path);
            }
            catch (IOException ex) {
                log.warn("Unable to write profiles while removing search path {}", (Object)path.getPath(), (Object)ex);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnRemoveSearchPath.errorMessage", path.getPath(), ex.getLocalizedMessage()), Bundle.getMessage("ProfilePreferencesPanel.btnRemoveSearchPath.errorTitle"), 0);
            }
        }
    }

    private void btnExportProfileActionPerformed(ActionEvent evt) {
        Profile p = ProfileManager.getDefault().getProfiles(this.profilesTbl.getSelectedRow());
        if (p == null) {
            return;
        }
        JmriJFileChooser chooser = new JmriJFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("ZIP Archives", "zip"));
        chooser.setFileView(new ProfileFileView());
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(new File(p.getName() + ".zip"));
        if (chooser.showSaveDialog(this) == 0) {
            try {
                int result;
                if (chooser.getSelectedFile().exists()) {
                    int result2 = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.overwriteMessage", chooser.getSelectedFile().getName(), chooser.getSelectedFile().getParentFile().getName()), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.overwriteTitle"), 0, 2);
                    if (result2 == 0) {
                        if (!chooser.getSelectedFile().delete()) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.failureToDeleteMessage", chooser.getSelectedFile().getName(), chooser.getSelectedFile().getParentFile().getName()), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.failureToDeleteTitle"), 0);
                        }
                    } else {
                        this.btnExportProfileActionPerformed(evt);
                        return;
                    }
                }
                boolean exportExternalUserFiles = false;
                boolean exportExternalRoster = false;
                if (!new File(FileUtil.getUserFilesPath()).getCanonicalPath().startsWith(p.getPath().getCanonicalPath()) && (result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.externalUserFilesMessage"), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.externalUserFilesTitle"), 0, 3)) == 0) {
                    exportExternalUserFiles = true;
                }
                if (!new File(Roster.getDefault().getRosterLocation()).getCanonicalPath().startsWith(p.getPath().getCanonicalPath()) && !Roster.getDefault().getRosterLocation().startsWith(FileUtil.getUserFilesPath()) && (result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.externalRosterMessage"), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.externalRosterTitle"), 0, 3)) == 0) {
                    exportExternalRoster = true;
                }
                ProfileManager.getDefault().export(p, chooser.getSelectedFile(), exportExternalUserFiles, exportExternalRoster);
                log.info("Profile \"{}\" exported to \"{}\"", (Object)p.getName(), (Object)chooser.getSelectedFile().getName());
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.successMessage", p.getName(), chooser.getSelectedFile().getName()), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.successTitle"), 1);
            }
            catch (IOException | InitializationException | JDOMException ex) {
                log.warn("Unable to export profile \"{}\" to {}", new Object[]{p.getName(), chooser.getSelectedFile().getPath(), ex});
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.errorMessage", p.getName(), chooser.getSelectedFile().getPath(), ex.getLocalizedMessage()), Bundle.getMessage("ProfilePreferencesPanel.btnExportProfile.errorTitle"), 0);
            }
        }
    }

    private void btnActivateProfileActionPerformed(ActionEvent evt) {
        try {
            Profile p = ProfileManager.getDefault().getProfiles(this.profilesTbl.getSelectedRow());
            ProfileManager.getDefault().setNextActiveProfile(p);
            ProfileManager.getDefault().saveActiveProfile(p, ProfileManager.getDefault().isAutoStartActiveProfile());
        }
        catch (IOException ex) {
            log.error("Unable to save profile preferences", (Throwable)ex);
            JmriJOptionPane.showMessageDialog(this, "Usable to save profile preferences.\n" + ex.getLocalizedMessage(), "Error", 0);
        }
    }

    private void btnCreateNewProfileActionPerformed(ActionEvent evt) {
        AddProfileDialog apd = new AddProfileDialog((Frame)SwingUtilities.getWindowAncestor(this), true, true);
        apd.setLocationRelativeTo(this);
        apd.setVisible(true);
    }

    private void btnDeleteProfileActionPerformed(ActionEvent evt) {
        ArrayList<Profile> profiles = new ArrayList<Profile>(this.profilesTbl.getSelectedRowCount());
        for (int row : this.profilesTbl.getSelectedRows()) {
            profiles.add(ProfileManager.getDefault().getAllProfiles().get(row));
        }
        Object object = profiles.iterator();
        while (object.hasNext()) {
            int result;
            Profile deletedProfile = (Profile)object.next();
            if (!Profile.isProfile(deletedProfile.getPath())) {
                result = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.dlgMessageNotAProfile", deletedProfile.getName(), deletedProfile.getPath()), Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.dlgTitle", deletedProfile.getName()), 2, 3, null, new String[]{Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.text"), Bundle.getMessage("AddProfileDialog.btnCancel.text")}, 2);
                if (result == 0) {
                    ProfileManager.getDefault().removeProfile(deletedProfile);
                    log.info("Removed profile \"{}\" left directory {}", (Object)deletedProfile.getName(), (Object)deletedProfile.getPath());
                    this.setCursor(Cursor.getDefaultCursor());
                    this.profilesTbl.repaint();
                }
            } else {
                result = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.dlgMessage", deletedProfile.getName(), deletedProfile.getPath(), "AAAAA"), Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.dlgTitle", deletedProfile.getName()), 2, 3, null, new String[]{Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.text"), Bundle.getMessage("AddProfileDialog.btnCancel.text")}, 2);
                if (result == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (!FileUtil.delete(deletedProfile.getPath())) {
                        log.warn("Unable to delete profile directory {}", (Object)deletedProfile.getPath());
                        this.setCursor(Cursor.getDefaultCursor());
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.errorMessage", deletedProfile.getPath()), Bundle.getMessage("ProfilePreferencesPanel.btnDeleteProfile.errorMessage"), 0);
                        this.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    ProfileManager.getDefault().removeProfile(deletedProfile);
                    log.info("Removed profile \"{}\" from {}", (Object)deletedProfile.getName(), (Object)deletedProfile.getPath());
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.profilesTbl.repaint();
        }
    }

    private void btnOpenExistingProfileActionPerformed(ActionEvent evt) {
        JmriJFileChooser chooser = new JmriJFileChooser(FileUtil.getHomePath());
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new ProfileFileFilter());
        chooser.setFileView(new ProfileFileView());
        if (chooser.showOpenDialog(this) == 0) {
            try {
                if (!Profile.isProfile(chooser.getSelectedFile())) {
                    log.warn("{} is not a profile directory", (Object)chooser.getSelectedFile());
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("addExistingNotAProfile", chooser.getSelectedFile()), Bundle.getMessage("addExistingNotAProfile"), 0);
                    return;
                }
                Profile p = new Profile(chooser.getSelectedFile());
                ProfileManager.getDefault().addProfile(p);
                int index = ProfileManager.getDefault().getAllProfiles().indexOf(p);
                this.profilesTbl.setRowSelectionInterval(index, index);
            }
            catch (IOException ex) {
                log.warn("Unexpected error in new Profile({})", (Object)chooser.getSelectedFile(), (Object)ex);
                return;
            }
        }
    }

    private void btnCopyProfileActionPerformed(ActionEvent evt) {
        AddProfileDialog apd = new AddProfileDialog((Frame)SwingUtilities.getWindowAncestor(this), true, true);
        apd.setSourceProfile(ProfileManager.getDefault().getAllProfiles().get(this.profilesTbl.getSelectedRow()));
        apd.setLocationRelativeTo(this);
        apd.setVisible(true);
    }

    private void spinnerTimeoutStateChanged(ChangeEvent evt) {
        ProfileManager.getDefault().setAutoStartActiveProfileTimeout((Integer)this.spinnerTimeout.getValue());
        try {
            ProfileManager.getDefault().saveActiveProfile();
        }
        catch (IOException ex) {
            log.error("Unable to save active profile.", (Throwable)ex);
        }
    }

    private void rdoStartWithActiveProfileActionPerformed(ActionEvent evt) {
        this.setAutoStartActiveProfile(true);
        this.spinnerTimeout.setEnabled(false);
    }

    private void rdoStartWithProfileSelectorActionPerformed(ActionEvent evt) {
        this.setAutoStartActiveProfile(false);
        this.spinnerTimeout.setEnabled(true);
    }

    private void setAutoStartActiveProfile(boolean automatic) {
        ProfileManager.getDefault().setAutoStartActiveProfile(automatic);
        try {
            ProfileManager.getDefault().saveActiveProfile();
        }
        catch (IOException ex) {
            log.error("Unable to save active profile.", (Throwable)ex);
        }
    }

    @Override
    public String getPreferencesItem() {
        return "Profiles";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("ProfilePreferencesPanel.enabledPanel.TabConstraints.tabTitle");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
    }

    @Override
    public int getSortOrder() {
        return 1000;
    }

    public void dispose() {
        ProfileManager.getDefault().removePropertyChangeListener((PropertyChangeListener)((Object)this.profilesTbl.getModel()));
    }

    private void profilesTblValueChanged(ListSelectionEvent e) {
        if (this.profilesTbl.getSelectedRowCount() == 1 && this.profilesTbl.getSelectedRow() < ProfileManager.getDefault().getAllProfiles().size()) {
            Profile p = ProfileManager.getDefault().getAllProfiles().get(this.profilesTbl.getSelectedRow());
            this.btnDeleteProfile.setEnabled(!p.equals(ProfileManager.getDefault().getActiveProfile()));
            if (ProfileManager.getDefault().getNextActiveProfile() != null) {
                this.btnActivateProfile.setEnabled(!p.equals(ProfileManager.getDefault().getNextActiveProfile()));
            } else {
                this.btnActivateProfile.setEnabled(!p.equals(ProfileManager.getDefault().getActiveProfile()));
            }
            this.btnCopyProfile.setEnabled(true);
            this.btnExportProfile.setEnabled(true);
        } else if (this.profilesTbl.getSelectedRowCount() > 1) {
            this.btnDeleteProfile.setEnabled(true);
            for (int row : this.profilesTbl.getSelectedRows()) {
                Profile p = ProfileManager.getDefault().getAllProfiles().get(row);
                if (!p.equals(ProfileManager.getDefault().getActiveProfile())) continue;
                this.btnDeleteProfile.setEnabled(false);
                break;
            }
            this.btnCopyProfile.setEnabled(false);
            this.btnExportProfile.setEnabled(false);
            this.btnActivateProfile.setEnabled(false);
        } else {
            this.btnDeleteProfile.setEnabled(false);
            this.btnCopyProfile.setEnabled(false);
            this.btnExportProfile.setEnabled(false);
            this.btnActivateProfile.setEnabled(false);
        }
    }

    private void searchPathsTblValueChanged(ListSelectionEvent e) {
        if (this.searchPathsTbl.getSelectedRowCount() == 1 && this.searchPathsTbl.getSelectedRow() < ProfileManager.getDefault().getAllSearchPaths().size()) {
            File sp = ProfileManager.getDefault().getSearchPaths(this.searchPathsTbl.getSelectedRow());
            if (sp == null || sp.equals(new File(FileUtil.getPreferencesPath()))) {
                this.btnRemoveSearchPath.setEnabled(false);
            } else {
                this.btnRemoveSearchPath.setEnabled(true);
            }
        } else if (this.searchPathsTbl.getSelectedRowCount() > 1) {
            this.btnRemoveSearchPath.setEnabled(true);
        } else {
            this.btnRemoveSearchPath.setEnabled(false);
        }
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isRestartRequired() {
        Profile ap = ProfileManager.getDefault().getActiveProfile();
        Profile np = ProfileManager.getDefault().getNextActiveProfile();
        return np != null && ap != null && !ap.equals(np);
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    private class ProfilesSelectionListener
    implements ListSelectionListener {
        private ProfilesSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ProfilePreferencesPanel.this.profilesTblValueChanged(e);
        }
    }

    private class SearchPathSelectionListener
    implements ListSelectionListener {
        private SearchPathSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ProfilePreferencesPanel.this.searchPathsTblValueChanged(e);
        }
    }
}

