/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import jmri.profile.AuxiliaryProperties;
import jmri.profile.Profile;
import jmri.util.prefs.JmriPreferencesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileProperties
implements AuxiliaryProperties {
    private final File path;
    private static final Logger log = LoggerFactory.getLogger(ProfileProperties.class);

    public ProfileProperties(Profile project) {
        this.path = project.getPath();
    }

    ProfileProperties(File path) {
        this.path = path;
    }

    @Override
    public String get(String key, boolean shared) {
        return JmriPreferencesProvider.getPreferences(this.path, null, shared).node("profile").get(key, null);
    }

    @Override
    public Iterable<String> listKeys(boolean shared) {
        try {
            String[] keys = JmriPreferencesProvider.getPreferences(this.path, null, shared).node("profile").keys();
            return new ArrayList<String>(Arrays.asList(keys));
        }
        catch (BackingStoreException ex) {
            log.error("Unable to read properties.", (Throwable)ex);
            return new ArrayList<String>();
        }
    }

    @Override
    public void put(String key, String value, boolean shared) {
        JmriPreferencesProvider.getPreferences(this.path, null, shared).node("profile").put(key, value);
    }
}

