/*
 * Decompiled with CFR 0.152.
 */
package jmri.profile;

import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import jmri.profile.AuxiliaryConfiguration;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.FileUtilSupport;
import jmri.util.node.NodeIdentity;
import jmri.util.prefs.JmriConfigurationProvider;
import jmri.util.prefs.JmriPreferencesProvider;
import jmri.util.prefs.JmriUserInterfaceConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileUtils {
    private static final Logger log = LoggerFactory.getLogger(ProfileUtils.class);

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(Profile project) {
        return JmriConfigurationProvider.getConfiguration(project);
    }

    public static Preferences getPreferences(Profile project, Class<?> clazz, boolean shared) {
        return JmriPreferencesProvider.getPreferences(project, clazz, shared);
    }

    public static AuxiliaryConfiguration getUserInterfaceConfiguration(Profile project) {
        return JmriUserInterfaceConfigurationProvider.getConfiguration(project);
    }

    public static File getCacheDirectory(Profile project, Class<?> owner) {
        File cache = FileUtilSupport.getDefault().getCacheDirectory();
        if (project != null) {
            cache = new File(cache, project.getId());
        }
        if (owner != null) {
            cache = new File(cache, JmriPreferencesProvider.findCNBForClass(owner));
        }
        FileUtil.createDirectory(cache);
        return cache;
    }

    public static void copy(@Nonnull Profile source, @Nonnull Profile destination) throws IllegalArgumentException, IOException {
        if (destination.equals(ProfileManager.getDefault().getActiveProfile())) {
            throw new IllegalArgumentException("Target profile cannot be active profile.");
        }
        FileUtil.copy(source.getPath(), destination.getPath());
        File profile = new File(destination.getPath(), "profile");
        File[] files = profile.listFiles(pathname -> pathname.getName().endsWith(source.getUniqueId()));
        if (files != null) {
            for (File file : files) {
                if (file.renameTo(new File(profile, file.getName().replace(source.getUniqueId(), destination.getUniqueId())))) continue;
                throw new IOException("Unable to rename " + file + " to use new profile ID");
            }
        }
        destination.save();
    }

    public static boolean copyPrivateContentToCurrentIdentity(@Nonnull Profile profile) throws IOException {
        String uniqueId = "-" + profile.getUniqueId();
        File newPath = new File(new File(profile.getPath(), "profile"), NodeIdentity.storageIdentity(profile));
        if (!newPath.exists()) {
            File oldPath = null;
            for (String identity : NodeIdentity.formerIdentities()) {
                File path;
                if (oldPath == null) {
                    path = new File(new File(profile.getPath(), "profile"), identity + uniqueId);
                    if (!path.exists()) continue;
                    oldPath = path;
                    continue;
                }
                path = new File(new File(profile.getPath(), "profile"), identity + uniqueId);
                if (!path.exists() || path.lastModified() <= oldPath.lastModified()) continue;
                oldPath = path;
            }
            if (oldPath != null && oldPath.exists()) {
                try {
                    log.info("Copying from old node \"{}\" to new node \"{}\"", (Object)oldPath, (Object)newPath);
                    FileUtil.copy(oldPath, newPath);
                    return true;
                }
                catch (IOException ex) {
                    log.warn("Failed copying \"{}\" to \"{}\"", (Object)oldPath, (Object)newPath);
                }
            }
        }
        return false;
    }
}

