/*
 * Decompiled with CFR 0.152.
 */
package jmri.progdebugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgDebugger
extends PropertyChangeSupport
implements AddressedProgrammer {
    private int _lastWriteVal = -1;
    private int _lastWriteCv = -1;
    public int nOperations = 0;
    Hashtable<Integer, Integer> mValues = new Hashtable();
    private int _nextRead = 123;
    private int _lastReadCv = -1;
    boolean confirmOK;
    protected ProgrammingMode mode;
    int writeLimit = 256;
    int readLimit = 256;
    boolean longAddr = true;
    int address = -1;
    static final boolean IMMEDIATERETURN = false;
    static final int DELAY = 10;
    private static final Logger log = LoggerFactory.getLogger(ProgDebugger.class);

    public ProgDebugger() {
        this.mode = ProgrammingMode.PAGEMODE;
    }

    public ProgDebugger(boolean pLongAddress, int pAddress) {
        this.longAddr = pLongAddress;
        this.address = pAddress;
        this.mode = ProgrammingMode.OPSBITMODE;
    }

    public int lastWrite() {
        return this._lastWriteVal;
    }

    public int lastWriteCv() {
        return this._lastWriteCv;
    }

    public void resetCv(int cv, int val) {
        this.mValues.put(cv, val);
    }

    public int getCvVal(int cv) {
        Integer saw = this.mValues.get(cv);
        if (saw != null) {
            return saw;
        }
        log.warn("CV {} has no defined value", (Object)cv);
        return -1;
    }

    public boolean hasBeenWritten(int cv) {
        Integer saw = this.mValues.get(cv);
        return saw != null;
    }

    public void clearHasBeenWritten(int cv) {
        this.mValues.remove(cv);
    }

    @Override
    @Nonnull
    public String decodeErrorCode(int i) {
        log.debug("decoderErrorCode {}", (Object)i);
        return "error " + i;
    }

    @Override
    public void writeCV(String CVname, final int val, ProgListener p) throws ProgrammerException {
        if (CVname.contains(".")) {
            String[] parts = CVname.split("\\.");
            CVname = parts[1];
        }
        int CV = Integer.parseInt(CVname);
        ++this.nOperations;
        final ProgListener m = p;
        log.info("write CV: {} to: {} mode: {}", new Object[]{CV, val, this.getMode()});
        this._lastWriteVal = val;
        this._lastWriteCv = CV;
        this.mValues.put(CV, val);
        Runnable r = new Runnable(){
            ProgListener l;
            {
                this.l = m;
            }

            @Override
            public void run() {
                log.debug("write CV reply");
                if (this.l != null) {
                    ProgDebugger.this.notifyProgListenerEnd(this.l, val, 0);
                }
            }
        };
        this.sendReturn(r);
    }

    public void nextRead(int r) {
        this._nextRead = r;
    }

    public int lastReadCv() {
        return this._lastReadCv;
    }

    @Override
    public void confirmCV(String CVname, final int val, ProgListener p) throws ProgrammerException {
        int result;
        int CV = Integer.parseInt(CVname);
        final ProgListener m = p;
        ++this.nOperations;
        Integer saw = this.mValues.get(CV);
        if (saw != null) {
            result = saw;
            this.confirmOK = result == val;
            log.info("confirm CV: {} mode: {} will return {} pass: {}", new Object[]{CV, this.getMode(), result, this.confirmOK});
        } else {
            result = -1;
            this.confirmOK = false;
            log.info("confirm CV: {} mode: {} will return -1 pass: false due to no previous value", (Object)CV, (Object)this.getMode());
        }
        this._lastReadCv = CV;
        final int returnResult = result;
        Runnable r = new Runnable(){
            ProgListener l;
            int res;
            {
                this.l = m;
                this.res = returnResult;
            }

            @Override
            public void run() {
                log.debug("read CV reply");
                if (ProgDebugger.this.confirmOK) {
                    ProgDebugger.this.notifyProgListenerEnd(this.l, val, 0);
                } else {
                    ProgDebugger.this.notifyProgListenerEnd(this.l, this.res, 64);
                }
            }
        };
        this.sendReturn(r);
    }

    @Override
    public void readCV(String CVname, ProgListener p) throws ProgrammerException {
        if (CVname.contains(".")) {
            String[] parts = CVname.split("\\.");
            CVname = parts[1];
        }
        int CV = Integer.parseInt(CVname);
        final ProgListener m = p;
        this._lastReadCv = CV;
        ++this.nOperations;
        int readValue = this._nextRead;
        Integer saw = this.mValues.get(CV);
        if (saw != null) {
            readValue = saw;
        }
        log.info("read CV: {} mode: {} will read {}", new Object[]{CV, this.getMode(), readValue});
        final int returnValue = readValue;
        Runnable r = new Runnable(){
            int retval;
            ProgListener l;
            {
                this.retval = returnValue;
                this.l = m;
            }

            @Override
            public void run() {
                log.debug("read CV reply");
                ProgDebugger.this.notifyProgListenerEnd(this.l, this.retval, 0);
            }
        };
        this.sendReturn(r);
    }

    @Override
    public final void setMode(ProgrammingMode m) {
        log.debug("Setting mode from {} to {}", (Object)this.mode, (Object)m);
        if (!this.getSupportedModes().contains(m)) {
            throw new IllegalArgumentException("Invalid requested mode: " + m);
        }
        ProgrammingMode oldMode = this.mode;
        this.mode = m;
        this.firePropertyChange("Mode", oldMode, m);
    }

    @Override
    public final ProgrammingMode getMode() {
        return this.mode;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        if (this.address >= 0) {
            return Arrays.asList(ProgrammingMode.OPSBITMODE, ProgrammingMode.OPSBYTEMODE);
        }
        return Arrays.asList(ProgrammingMode.PAGEMODE, ProgrammingMode.DIRECTBITMODE, ProgrammingMode.DIRECTBYTEMODE, ProgrammingMode.DIRECTMODE);
    }

    public void setTestReadLimit(int lim) {
        this.readLimit = lim;
    }

    public void setTestWriteLimit(int lim) {
        this.writeLimit = lim;
    }

    @Override
    public boolean getCanRead() {
        log.debug("getCanRead() returns true");
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        log.debug("getCanRead({}) returns {}", (Object)addr, (Object)(Integer.parseInt(addr) <= this.readLimit ? 1 : 0));
        return Integer.parseInt(addr) <= this.readLimit;
    }

    @Override
    public boolean getCanWrite() {
        log.debug("getCanWrite() returns true");
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        log.debug("getCanWrite({}) returns {}", (Object)addr, (Object)(Integer.parseInt(addr) <= this.writeLimit ? 1 : 0));
        return Integer.parseInt(addr) <= this.writeLimit;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        return Programmer.WriteConfirmMode.NotVerified;
    }

    @Override
    public boolean getLongAddress() {
        return true;
    }

    @Override
    public int getAddressNumber() {
        return this.address;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void sendReturn(Runnable run) {
        Timer timer = new Timer(10, null);
        ActionListener l = new ActionListener(){
            Timer myTimer;
            Runnable runnable;

            ActionListener init(Timer t, Runnable r) {
                this.myTimer = t;
                this.runnable = r;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.myTimer.stop();
                SwingUtilities.invokeLater(this.runnable);
            }
        }.init(timer, run);
        timer.addActionListener(l);
        timer.start();
    }
}

