/*
 * Decompiled with CFR 0.152.
 */
package jmri.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import jmri.InstanceManagerAutoDefault;
import jmri.script.JmriScriptEngineManager;
import jmri.script.ScriptEngineSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalScriptEngineSelector
implements InstanceManagerAutoDefault {
    private final ScriptEngineSelector.Engine _defaultEngine;
    private final List<ScriptEngineSelector.Engine> _engines = new ArrayList<ScriptEngineSelector.Engine>();
    private final Map<String, ScriptEngineSelector.Engine> _engineMap = new HashMap<String, ScriptEngineSelector.Engine>();
    private final Set<String> languageNames = new HashSet<String>();
    private static final Logger log = LoggerFactory.getLogger(InternalScriptEngineSelector.class);

    public InternalScriptEngineSelector() {
        JmriScriptEngineManager.getDefault().getManager().getEngineFactories().stream().forEach(factory -> {
            String name;
            String version = factory.getEngineVersion();
            if (version != null && !this.languageNames.contains(name = JmriScriptEngineManager.fileForLanguage(factory.getEngineName(), factory.getLanguageName()))) {
                String languageName = factory.getLanguageName();
                try {
                    this.languageNames.add(name);
                    ScriptEngineSelector.Engine engine = new ScriptEngineSelector.Engine(name, languageName);
                    this._engines.add(engine);
                    this._engineMap.put(languageName, engine);
                }
                catch (ScriptException e) {
                    log.error("Cannot load script engine {}, {}", (Object)name, (Object)languageName);
                }
            }
        });
        this._defaultEngine = this._engineMap.containsKey("python") ? this._engineMap.get("python") : (!this._engineMap.isEmpty() ? this._engineMap.values().iterator().next() : null);
    }

    ScriptEngineSelector.Engine getDefaultEngine() {
        return this._defaultEngine;
    }

    ScriptEngineSelector.Engine getEngineFromLanguage(String language) {
        return this._engineMap.get(language);
    }

    @Nonnull
    public List<ScriptEngineSelector.Engine> getAllEngines() {
        return Collections.unmodifiableList(this._engines);
    }
}

