/*
 * Decompiled with CFR 0.152.
 */
package jmri.script;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jmri.InstanceManager;
import jmri.script.InternalScriptEngineSelector;
import jmri.script.JmriScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineSelector {
    public static final String JYTHON = "python";
    public static final String ECMA_SCRIPT = "ECMAScript";
    private Engine _selectedEngine = InstanceManager.getDefault(InternalScriptEngineSelector.class).getDefaultEngine();
    private static final Logger log = LoggerFactory.getLogger(ScriptEngineSelector.class);

    @CheckForNull
    public Engine getSelectedEngine() {
        return this._selectedEngine;
    }

    public void setSelectedEngine(@Nonnull Engine engine) {
        this._selectedEngine = engine;
    }

    public void setSelectedEngine(@Nonnull String languageName) {
        Engine engine = InstanceManager.getDefault(InternalScriptEngineSelector.class).getEngineFromLanguage(languageName);
        if (engine != null) {
            this.setSelectedEngine(engine);
        } else {
            log.warn("Cannot select engine for the language {}", (Object)languageName);
        }
    }

    @Nonnull
    public static List<Engine> getAllEngines() {
        return Collections.unmodifiableList(InstanceManager.getDefault(InternalScriptEngineSelector.class).getAllEngines());
    }

    public static class Engine {
        private final String _name;
        private final String _languageName;
        private final ScriptEngine _engine;

        Engine(String name, String id) throws ScriptException {
            this._name = name;
            this._languageName = id;
            this._engine = JmriScriptEngineManager.getDefault().getEngineByName(this._languageName);
            log.debug("Load script engine: {}, {}, {}", new Object[]{this._name, this._languageName, this._engine});
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        @Nonnull
        public String getLanguageName() {
            return this._languageName;
        }

        @Nonnull
        public ScriptEngine getScriptEngine() {
            return this._engine;
        }

        public boolean isJython() {
            return ScriptEngineSelector.JYTHON.equalsIgnoreCase(this._languageName) || "jython".equalsIgnoreCase(this._languageName);
        }

        public boolean isJavaScript() {
            return "javascript".equalsIgnoreCase(this._languageName) || "ecmascript".equalsIgnoreCase(this._languageName);
        }

        public String toString() {
            return this._name;
        }
    }
}

