/*
 * Decompiled with CFR 0.152.
 */
package jmri.script.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.script.ScriptException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.script.JmriScriptEngineManager;
import jmri.script.ScriptEngineSelector;
import jmri.script.swing.Bundle;
import jmri.script.swing.ScriptEngineSelectorSwing;
import jmri.script.swing.ScriptFileChooser;
import jmri.script.swing.ScriptOutput;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.python.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputWindow
extends JPanel {
    JTextArea area;
    JButton button;
    JButton loadButton;
    JButton storeButton;
    private UserPreferencesManager pref;
    JLabel status;
    JCheckBox alwaysOnTopCheckBox = new JCheckBox();
    private ScriptEngineSelector scriptEngineSelector = new ScriptEngineSelector();
    private ScriptEngineSelectorSwing scriptEngineSelectorSwing;
    JFileChooser userFileChooser = new ScriptFileChooser(FileUtil.getScriptsPath());
    public static final String languageSelection = InputWindow.class.getName() + ".language";
    public static final String alwaysOnTopChecked = InputWindow.class.getName() + ".alwaysOnTopChecked";
    private static final Logger log = LoggerFactory.getLogger(InputWindow.class);

    public InputWindow() {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        this.setLayout(new BorderLayout());
        this.area = new JTextArea(12, 50);
        this.area.addCaretListener(e -> {
            JTextArea editArea = (JTextArea)e.getSource();
            int linenum = 1;
            int columnnum = 1;
            try {
                int caretpos = editArea.getCaretPosition();
                linenum = editArea.getLineOfOffset(caretpos);
                columnnum = caretpos - editArea.getLineStartOffset(linenum);
                ++linenum;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.updateStatus(linenum, columnnum);
        });
        JScrollPane js = new JScrollPane(this.area);
        js.setHorizontalScrollBarPolicy(30);
        js.setVerticalScrollBarPolicy(20);
        this.add((Component)js, "Center");
        String preferredLanguage = this.pref.getComboBoxLastSelection(languageSelection);
        if (preferredLanguage != null) {
            boolean updatePreferredLanguage = false;
            if (preferredLanguage.equals(Bundle.getMessage("jython_python"))) {
                this.scriptEngineSelector.setSelectedEngine("python");
                updatePreferredLanguage = true;
            } else if (preferredLanguage.equals(Bundle.getMessage("Oracle_Nashorn_ECMAScript"))) {
                this.scriptEngineSelector.setSelectedEngine("ECMAScript");
                updatePreferredLanguage = true;
            } else {
                this.scriptEngineSelector.setSelectedEngine(preferredLanguage);
            }
            ScriptEngineSelector.Engine engine = this.scriptEngineSelector.getSelectedEngine();
            if (updatePreferredLanguage && engine != null) {
                this.pref.setComboBoxLastSelection(languageSelection, engine.getLanguageName());
            }
        }
        this.scriptEngineSelectorSwing = new ScriptEngineSelectorSwing(this.scriptEngineSelector);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.loadButton = new JButton(Bundle.getMessage("ButtonLoad_"));
        p.add(this.loadButton);
        this.storeButton = new JButton(Bundle.getMessage("ButtonStore_"));
        p.add(this.storeButton);
        p.add(this.scriptEngineSelectorSwing.getComboBox());
        this.button = new JButton(Bundle.getMessage("ButtonExecute"));
        p.add(this.button);
        this.alwaysOnTopCheckBox.setText(Bundle.getMessage("WindowAlwaysOnTop"));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("WindowAlwaysOnTopToolTip"));
        p.add(this.alwaysOnTopCheckBox);
        this.status = new JLabel("         ");
        p.add(this.status);
        this.updateStatus(1, 0);
        this.add((Component)p, "South");
        this.button.addActionListener(e -> this.buttonPressed());
        this.loadButton.addActionListener(e -> this.loadButtonPressed());
        this.storeButton.addActionListener(e -> this.storeButtonPressed());
        this.scriptEngineSelectorSwing.getComboBox().addItemListener(e -> {
            JComboBox<ScriptEngineSelector.Engine> comboBox = this.scriptEngineSelectorSwing.getComboBox();
            ScriptEngineSelector.Engine engine = comboBox.getItemAt(comboBox.getSelectedIndex());
            this.pref.setComboBoxLastSelection(languageSelection, engine.getLanguageName());
        });
        this.alwaysOnTopCheckBox.addActionListener(e -> {
            if (this.getTopLevelAncestor() != null) {
                ((JmriJFrame)this.getTopLevelAncestor()).setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
            }
            this.pref.setSimplePreferenceState(alwaysOnTopChecked, this.alwaysOnTopCheckBox.isSelected());
        });
        this.alwaysOnTopCheckBox.setSelected(this.pref.getSimplePreferenceState(alwaysOnTopChecked));
        int size = this.area.getFont().getSize();
        this.area.setFont(new Font("Monospaced", 0, size));
    }

    private void updateStatus(int linenumber, int columnnumber) {
        this.status.setText("    " + linenumber + ":" + columnnumber);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Should crash if missing ScriptEngine dependencies are not present")
    protected boolean loadFile(JFileChooser fileChooser) {
        boolean results = false;
        File file = InputWindow.getFile(fileChooser);
        if (file != null) {
            try {
                try {
                    this.scriptEngineSelector.setSelectedEngine(JmriScriptEngineManager.getDefault().getFactoryByExtension(Files.getFileExtension((String)file.getName())).getLanguageName());
                    this.scriptEngineSelectorSwing.updateSetComboBoxSelection();
                }
                catch (ScriptException npe) {
                    log.error("Unable to identify script language for {}, assuming its Python.", (Object)file);
                    this.scriptEngineSelector.setSelectedEngine(JmriScriptEngineManager.getDefault().getFactory("jython").getLanguageName());
                    this.scriptEngineSelectorSwing.updateSetComboBoxSelection();
                }
                StringBuilder fileData = new StringBuilder(1024);
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    int numRead;
                    char[] buf = new char[1024];
                    while ((numRead = reader.read(buf)) != -1) {
                        String readData = String.valueOf(buf, 0, numRead);
                        fileData.append(readData);
                        buf = new char[1024];
                    }
                }
                this.area.setText(fileData.toString());
                results = true;
            }
            catch (IOException e) {
                log.error("Unhandled problem in loadFile", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    protected boolean storeFile(JFileChooser fileChooser) {
        boolean results = false;
        File file = InputWindow.getFile(fileChooser);
        if (file != null) {
            try {
                int selectedValue;
                if (file.exists() && (selectedValue = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("ConfirmDialogMessage", file.getName()), Bundle.getMessage("ConfirmDialogTitle"), 2)) != 0) {
                    return false;
                }
                StringBuilder fileData = new StringBuilder(this.area.getText());
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.append(fileData);
                }
                results = true;
            }
            catch (HeadlessException | IOException e) {
                log.error("Unhandled problem in storeFile", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    public static File getFile(JFileChooser fileChooser) {
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showDialog(null, null);
        if (retVal != 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Open file: {}", (Object)fileChooser.getSelectedFile().getPath());
        }
        return fileChooser.getSelectedFile();
    }

    void loadButtonPressed() {
        this.userFileChooser.setDialogType(0);
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("MenuItemLoad"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("MenuItemLoad"));
        boolean results = this.loadFile(this.userFileChooser);
        log.debug("load {}", (Object)(results ? "was successful" : "failed"));
        if (!results) {
            log.warn("Not loading file: {}", (Object)this.userFileChooser.getSelectedFile().getPath());
        }
    }

    void storeButtonPressed() {
        this.userFileChooser.setDialogType(1);
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("MenuItemStore"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("MenuItemStore"));
        boolean results = this.storeFile(this.userFileChooser);
        log.debug("store {}", (Object)(results ? "was successful" : "failed"));
        if (!results) {
            log.warn("Not storing file: {}", (Object)this.userFileChooser.getSelectedFile().getPath());
        }
    }

    public void buttonPressed() {
        ScriptOutput.writeScript(this.area.getText());
        try {
            ScriptEngineSelector.Engine engine = this.scriptEngineSelector.getSelectedEngine();
            if (engine == null) {
                throw new NullPointerException("scriptEngineSelector.getSelectedEngine() returns null");
            }
            JmriScriptEngineManager.getDefault().eval(this.area.getText(), engine.getScriptEngine());
        }
        catch (ScriptException ex) {
            log.error("Error executing script", (Throwable)ex);
        }
    }
}

