/*
 * Decompiled with CFR 0.152.
 */
package jmri.script.swing;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.script.JmriScriptEngineManager;
import jmri.script.swing.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptFileChooser
extends JmriJFileChooser {
    private static final Logger log = LoggerFactory.getLogger(ScriptFileChooser.class);

    public ScriptFileChooser() {
        super(FileUtil.getScriptsPath());
        this.init();
    }

    public ScriptFileChooser(String path) {
        super(path);
        this.init();
    }

    public ScriptFileChooser(File dir) {
        super(dir);
        this.init();
    }

    private void init() {
        ArrayList allExtensions = new ArrayList();
        HashMap filters = new HashMap();
        ArrayList filterNames = new ArrayList();
        JmriScriptEngineManager.getDefault().getManager().getEngineFactories().stream().forEach(factory -> {
            log.debug("processing factory {} for {}", factory, (Object)factory.getLanguageName());
            String version = factory.getEngineVersion();
            if (version != null) {
                List<String> extensions = factory.getExtensions();
                allExtensions.addAll(extensions);
                String name = JmriScriptEngineManager.fileForLanguage(factory.getEngineName(), factory.getLanguageName());
                filterNames.add(name);
                if (!extensions.isEmpty()) {
                    filters.put(name, new FileNameExtensionFilter(name, extensions.toArray(new String[extensions.size()])));
                } else {
                    log.warn("Found no valid extensions for language {} version {}", (Object)factory.getLanguageName(), (Object)version);
                }
            }
        });
        FileNameExtensionFilter allScripts = new FileNameExtensionFilter(Bundle.getMessage("allScripts"), allExtensions.toArray(new String[allExtensions.size()]));
        this.addChoosableFileFilter(allScripts);
        filterNames.stream().sorted().forEach(filter -> this.addChoosableFileFilter((FileFilter)filters.get(filter)));
        this.setFileFilter(allScripts);
        this.setFileSelectionMode(0);
    }
}

