/*
 * Decompiled with CFR 0.152.
 */
package jmri.script.swing;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import javax.script.ScriptContext;
import javax.swing.JTextArea;
import jmri.InstanceManager;
import jmri.script.JmriScriptEngineManager;
import jmri.util.PipeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptOutput {
    private JTextArea output = null;
    private static final Logger log = LoggerFactory.getLogger(ScriptOutput.class);

    public JTextArea getOutputArea() {
        if (this.output == null) {
            try {
                this.output = new JTextArea();
                PipedWriter pw = new PipedWriter();
                ScriptContext context = JmriScriptEngineManager.getDefault().getDefaultContext();
                context.setErrorWriter(pw);
                context.setWriter(pw);
                PipedReader pr = new PipedReader(pw);
                PipeListener pl = new PipeListener(pr, this.output);
                pl.setName("ScriptOutput PipeListener");
                pl.setDaemon(true);
                pl.start();
            }
            catch (IOException e) {
                log.error("Exception creating script output area", (Throwable)e);
                return null;
            }
        }
        return this.output;
    }

    public static ScriptOutput getDefault() {
        if (InstanceManager.getNullableDefault(ScriptOutput.class) == null) {
            InstanceManager.store(new ScriptOutput(), ScriptOutput.class);
        }
        return InstanceManager.getDefault(ScriptOutput.class);
    }

    public static void writeScript(String script) {
        Object output = ">>> " + script;
        while (((String)output).endsWith("\n")) {
            output = ((String)output).substring(0, ((String)output).length() - 1);
        }
        output = ((String)output).replaceAll("\n", "\n... ");
        output = (String)output + "\n";
        ScriptOutput.getDefault().getOutputArea().append((String)output);
    }
}

