/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.server.json.Bundle;
import jmri.server.json.JSON;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonServerPreferences;
import jmri.server.json.JsonSocketService;
import jmri.server.json.schema.JsonSchemaServiceCache;
import jmri.spi.JsonServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonClientHandler {
    public static final String HELLO_MSG = "{\"type\":\"hello\"}";
    private final JsonConnection connection;
    private final HashMap<String, HashSet<JsonSocketService<?>>> services = new HashMap();
    private final JsonServerPreferences preferences = InstanceManager.getDefault(JsonServerPreferences.class);
    private final JsonSchemaServiceCache schemas = InstanceManager.getDefault(JsonSchemaServiceCache.class);
    private static final Logger log = LoggerFactory.getLogger(JsonClientHandler.class);

    public JsonClientHandler(JsonConnection connection) {
        this.connection = connection;
        String version = connection.getVersion();
        try {
            this.setVersion(version, 0);
        }
        catch (JsonException e) {
            log.error("Unable to create handler for version {}", (Object)version);
            throw new IllegalArgumentException();
        }
    }

    public void onClose() {
        this.services.values().forEach(set -> set.stream().forEach(JsonSocketService::onClose));
        this.services.clear();
    }

    public void onMessage(String string) throws IOException {
        if (string.equals("{\"type\":\"ping\"}")) {
            log.trace("Received from client: '{}'", (Object)string);
        } else {
            log.debug("Received from client: '{}'", (Object)string);
        }
        try {
            this.onMessage(this.connection.getObjectMapper().readTree(string));
        }
        catch (JsonProcessingException pe) {
            log.warn("Exception processing \"{}\"\n{}", (Object)string, (Object)pe.getMessage());
            this.sendErrorMessage(500, Bundle.getMessage(this.connection.getLocale(), "ErrorProcessingJSON", pe.getLocalizedMessage()), 0);
        }
    }

    public void onMessage(JsonNode root) throws IOException {
        String method = root.path("method").asText("get");
        String type = root.path("type").asText();
        int id = root.path("id").asInt(0);
        JsonNode data = root.path("data");
        JsonRequest request = new JsonRequest(this.connection.getLocale(), this.connection.getVersion(), method, id);
        try {
            if (this.preferences.getValidateClientMessages()) {
                this.schemas.validateMessage(root, false, request);
            }
            if ((root.path("type").isMissingNode() || type.equals("list")) && root.path("list").isValueNode()) {
                type = root.path("list").asText();
                method = "list";
            }
            if (data.isMissingNode()) {
                if (type.equals("hello") || type.equals("ping") || type.equals("goodbye") || method.equals("list") || method.equals("get")) {
                    data = this.connection.getObjectMapper().createObjectNode();
                } else {
                    this.sendErrorMessage(400, Bundle.getMessage(this.connection.getLocale(), "ErrorMissingData"), id);
                    return;
                }
            }
            if (root.path("method").isMissingNode() && data.path("method").isValueNode()) {
                method = data.path("method").asText("get");
            }
            if (type.equals("ping")) {
                log.trace("Processing '{}' with '{}'", (Object)type, (Object)data);
            } else {
                log.debug("Processing '{}' with '{}'", (Object)type, (Object)data);
            }
            if (method.equals("list")) {
                if (this.services.get(type) != null) {
                    for (JsonSocketService<?> service : this.services.get(type)) {
                        service.onList(type, data, request);
                    }
                } else {
                    log.warn("Requested list type '{}' unknown.", (Object)type);
                    this.sendErrorMessage(404, Bundle.getMessage(this.connection.getLocale(), "ErrorUnknownType", type), id);
                }
                return;
            }
            if (type.equals("hello") || type.equals("locale") && !data.path("locale").isMissingNode()) {
                this.connection.setLocale(Locale.forLanguageTag(data.path("locale").asText(this.connection.getLocale().getLanguage())));
                this.setVersion(data.path("version").asText(this.connection.getVersion()), id);
                request = new JsonRequest(this.connection.getLocale(), this.connection.getVersion(), method, id);
            }
            if (this.services.get(type) != null) {
                for (JsonSocketService<?> service : this.services.get(type)) {
                    service.onMessage(type, data, request);
                }
            } else {
                log.warn("Requested type '{}' unknown.", (Object)type);
                this.sendErrorMessage(404, Bundle.getMessage(this.connection.getLocale(), "ErrorUnknownType", type), id);
            }
            if (type.equals("goodbye")) {
                this.connection.close();
            }
        }
        catch (JmriException je) {
            log.warn("Unsupported operation attempted {}", (Object)root);
            this.sendErrorMessage(500, Bundle.getMessage(this.connection.getLocale(), "ErrorUnsupportedOperation", je.getLocalizedMessage()), id);
        }
        catch (JsonException je) {
            this.sendErrorMessage(je);
        }
    }

    private void sendErrorMessage(int code, String message, int id) throws IOException {
        JsonException ex = new JsonException(code, message, id);
        this.sendErrorMessage(ex);
    }

    private void sendErrorMessage(JsonException ex) throws IOException {
        this.connection.sendMessage(ex.getJsonMessage(), ex.getId());
    }

    private void setVersion(@Nonnull String version, int id) throws JsonException {
        if (JSON.VERSIONS.stream().noneMatch(v -> v.equals(version))) {
            throw new JsonException(404, Bundle.getMessage(this.connection.getLocale(), "ErrorUnknownType", version), id);
        }
        this.connection.setVersion(version);
        this.onClose();
        ServiceLoader.load(JsonServiceFactory.class).forEach(factory -> {
            Object service = factory.getSocketService(this.connection, version);
            Arrays.stream(factory.getTypes(version)).forEach(type -> {
                HashSet<JsonSocketService<?>> set = this.services.get(type);
                if (set == null) {
                    this.services.put((String)type, new HashSet());
                    set = this.services.get(type);
                }
                set.add((JsonSocketService<?>)service);
            });
            Arrays.stream(factory.getReceivedTypes(version)).forEach(type -> {
                HashSet<JsonSocketService<?>> set = this.services.get(type);
                if (set == null) {
                    this.services.put((String)type, new HashSet());
                    set = this.services.get(type);
                }
                set.add((JsonSocketService<?>)service);
            });
        });
    }

    protected HashMap<String, HashSet<JsonSocketService<?>>> getServices() {
        return new HashMap(this.services);
    }
}

