/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.jmris.JmriConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonServerPreferences;
import jmri.server.json.schema.JsonSchemaServiceCache;
import org.eclipse.jetty.websocket.api.Session;

public class JsonConnection
extends JmriConnection {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String version = "v5";
    protected final JsonServerPreferences preferences = InstanceManager.getDefault(JsonServerPreferences.class);
    protected final JsonSchemaServiceCache schemas = InstanceManager.getDefault(JsonSchemaServiceCache.class);

    public JsonConnection(Session connection) {
        super(connection);
    }

    public JsonConnection(DataOutputStream output) {
        super(output);
    }

    @Nonnull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void sendMessage(@Nonnull JsonNode message, @Nonnull JsonRequest request) throws IOException {
        if (this.preferences.getValidateServerMessages()) {
            try {
                this.schemas.validateMessage(message, true, request);
            }
            catch (JsonException ex) {
                super.sendMessage(this.getObjectMapper().writeValueAsString((Object)ex.getJsonMessage()));
                return;
            }
        }
        super.sendMessage(this.getObjectMapper().writeValueAsString((Object)message));
    }

    public void sendMessage(@Nonnull JsonNode message, int id) throws IOException {
        this.sendMessage(message, new JsonRequest(this.getLocale(), this.getVersion(), "get", id));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

