/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.server.json.Bundle;
import jmri.server.json.JsonDeleteTokenManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;

public abstract class JsonHttpService {
    protected final ObjectMapper mapper;

    protected JsonHttpService(@Nonnull ObjectMapper mapper) {
        this.mapper = mapper;
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Nonnull
    public abstract JsonNode doGet(@Nonnull String var1, @Nonnull String var2, @Nonnull JsonNode var3, @Nonnull JsonRequest var4) throws JsonException;

    @Nonnull
    public abstract JsonNode doPost(@Nonnull String var1, @Nonnull String var2, @Nonnull JsonNode var3, @Nonnull JsonRequest var4) throws JsonException;

    @Nonnull
    public JsonNode doPut(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PutNotAllowed", type), request.id);
    }

    public void doDelete(@Nonnull String type, @Nonnull String name, @Nonnull JsonNode data, @Nonnull JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "DeleteNotAllowed", type), request.id);
    }

    @Nonnull
    public abstract JsonNode doGetList(@Nonnull String var1, @Nonnull JsonNode var2, @Nonnull JsonRequest var3) throws JsonException;

    @Nonnull
    public abstract JsonNode doSchema(@Nonnull String var1, boolean var2, @Nonnull JsonRequest var3) throws JsonException;

    @Nonnull
    protected final JsonNode doSchema(@Nonnull String type, boolean server, @Nonnull String serverSchema, @Nonnull String clientSchema, int id) throws JsonException {
        JsonNode schema;
        try {
            schema = server ? this.mapper.readTree(this.getClass().getClassLoader().getResource(serverSchema)) : this.mapper.readTree(this.getClass().getClassLoader().getResource(clientSchema));
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new JsonException(500, ex, id);
        }
        return this.doSchema(type, server, schema, id);
    }

    @Nonnull
    protected final JsonNode doSchema(@Nonnull String type, boolean server, @Nonnull JsonNode schema, int id) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", type);
        data.put("server", server);
        data.set("schema", schema);
        return this.message("schema", (JsonNode)data, id);
    }

    @Nonnull
    public final ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public final boolean acceptForceDeleteToken(@Nonnull String type, @Nonnull String name, @CheckForNull String token) {
        return JsonDeleteTokenManager.getDefault().acceptToken(type, name, token);
    }

    public final void throwDeleteConflictException(@Nonnull String type, @Nonnull String name, @Nonnull ArrayNode conflicts, @Nonnull JsonRequest request) throws JsonException {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("forceDelete", JsonDeleteTokenManager.getDefault().getToken(type, name));
        if (conflicts.size() != 0) {
            data.set("conflict", (JsonNode)conflicts);
        }
        throw new JsonException(409, Bundle.getMessage(request.locale, "ErrorDeleteConflict", type, name), data, request.id);
    }

    public final JsonNode message(@Nonnull ArrayNode data, int id) {
        return JsonHttpService.message(this.mapper, data, null, id);
    }

    public final ObjectNode message(@Nonnull String type, @Nonnull JsonNode data, int id) {
        return this.message(type, data, null, id);
    }

    public final ObjectNode message(@Nonnull String type, @Nonnull JsonNode data, @CheckForNull String method, int id) {
        return JsonHttpService.message(this.mapper, type, data, method, id);
    }

    public static final JsonNode message(@Nonnull ObjectMapper mapper, @Nonnull ArrayNode data, @CheckForNull String method, int id) {
        return id > 0 ? JsonHttpService.message(mapper, "list", (JsonNode)data, method, id) : data;
    }

    public static final ObjectNode message(@Nonnull ObjectMapper mapper, @Nonnull String type, @Nonnull JsonNode data, @CheckForNull String method, int id) {
        ObjectNode root = mapper.createObjectNode();
        root.put("type", type);
        root.set("data", data);
        if (method != null) {
            root.put("method", method);
        }
        if (id > 0) {
            root.put("id", id);
        }
        return root;
    }
}

