/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNamedBeanSocketService<T extends NamedBean, H extends JsonNamedBeanHttpService<T>>
extends JsonSocketService<H> {
    protected final HashMap<T, NamedBeanListener> beanListeners = new HashMap();
    protected final ManagerListener managerListener = new ManagerListener();
    private static final Logger log = LoggerFactory.getLogger(JsonNamedBeanSocketService.class);

    public JsonNamedBeanSocketService(JsonConnection connection, H service) {
        super(connection, service);
        ((JsonNamedBeanHttpService)service).getManager().addPropertyChangeListener(this.managerListener);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        String name = data.path("name").asText();
        NamedBean bean = null;
        if (!request.method.equals("put") && (bean = (NamedBean)((JsonNamedBeanHttpService)this.service).getManager().getBySystemName(name)) == null && (bean = (NamedBean)((JsonNamedBeanHttpService)this.service).getManager().getByUserName(name)) != null) {
            log.warn("{} request for {} made with user name \"{}\"; should use system name", new Object[]{request.method, type, name});
            name = bean.getSystemName();
        }
        switch (request.method) {
            case "delete": {
                ((JsonNamedBeanHttpService)this.service).doDelete(type, name, data, request);
                break;
            }
            case "post": {
                this.connection.sendMessage(((JsonNamedBeanHttpService)this.service).doPost(type, name, data, request), request.id);
                break;
            }
            case "put": {
                JsonNode message = ((JsonNamedBeanHttpService)this.service).doPut(type, name, data, request);
                this.connection.sendMessage(message, request.id);
                bean = (NamedBean)((JsonNamedBeanHttpService)this.service).getManager().getBySystemName(message.path("data").path("name").asText());
                break;
            }
            default: {
                this.connection.sendMessage(((JsonNamedBeanHttpService)this.service).doGet(type, name, data, request), request.id);
            }
        }
        if (!this.beanListeners.containsKey(bean)) {
            this.addListenerToBean(bean);
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonNamedBeanHttpService)this.service).doGetList(type, data, request), request.id);
    }

    @Override
    public void onClose() {
        this.beanListeners.values().stream().forEach(listener -> listener.bean.removePropertyChangeListener((PropertyChangeListener)listener));
        this.beanListeners.clear();
        ((JsonNamedBeanHttpService)this.service).getManager().removePropertyChangeListener(this.managerListener);
    }

    protected void addListenerToBean(String name) {
        this.addListenerToBean(((JsonNamedBeanHttpService)this.service).getManager().getBySystemName(name));
    }

    protected void addListenerToBean(T bean) {
        if (bean != null) {
            NamedBeanListener listener = new NamedBeanListener(this, bean);
            bean.addPropertyChangeListener(listener);
            this.beanListeners.put(bean, listener);
        }
    }

    protected void removeListenersFromRemovedBeans() {
        for (NamedBean bean : new HashSet<T>(this.beanListeners.keySet())) {
            if (((JsonNamedBeanHttpService)this.service).getManager().getBySystemName(bean.getSystemName()) != null) continue;
            this.beanListeners.remove(bean);
        }
    }

    protected class ManagerListener
    implements PropertyChangeListener {
        protected ManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.handleChange(evt);
            }
            catch (IOException ex) {
                log.debug("deregistering reportersListener due to IOException");
                InstanceManager.getDefault(ReporterManager.class).removePropertyChangeListener(this);
            }
        }

        private void handleChange(PropertyChangeEvent evt) throws IOException {
            try {
                JsonNamedBeanSocketService.this.connection.sendMessage(((JsonNamedBeanHttpService)JsonNamedBeanSocketService.this.service).doGetList(((JsonNamedBeanHttpService)JsonNamedBeanSocketService.this.service).getType(), (JsonNode)((JsonNamedBeanHttpService)JsonNamedBeanSocketService.this.service).getObjectMapper().createObjectNode(), new JsonRequest(JsonNamedBeanSocketService.this.getLocale(), JsonNamedBeanSocketService.this.getVersion(), "get", 0)), 0);
                if (evt.getPropertyName().equals("length")) {
                    JsonNamedBeanSocketService.this.removeListenersFromRemovedBeans();
                }
            }
            catch (JsonException ex) {
                log.warn("json error sending {}: {}", (Object)((JsonNamedBeanHttpService)JsonNamedBeanSocketService.this.service).getType(), (Object)ex.getJsonMessage());
                JsonNamedBeanSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    protected static class NamedBeanListener
    implements PropertyChangeListener {
        public final T bean;
        final /* synthetic */ JsonNamedBeanSocketService this$0;

        public NamedBeanListener(T bean) {
            this.this$0 = this$0;
            this.bean = bean;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.this$0.connection.sendMessage((JsonNode)((JsonNamedBeanHttpService)this.this$0.service).doGet(this.bean, this.bean.getSystemName(), ((JsonNamedBeanHttpService)this.this$0.service).getType(), new JsonRequest(this.this$0.getLocale(), this.this$0.getVersion(), "get", 0)), 0);
            }
            catch (IOException | JsonException ex) {
                this.bean.removePropertyChangeListener(this);
                this.this$0.beanListeners.remove(this.bean);
            }
        }
    }
}

