/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.NamedBean;
import jmri.server.json.Bundle;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;

public abstract class JsonNonProvidedNamedBeanHttpService<T extends NamedBean>
extends JsonHttpService {
    public JsonNonProvidedNamedBeanHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Nonnull
    protected final JsonNode doGetList(Manager<T> manager, String type, JsonNode data, JsonRequest request) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        for (NamedBean bean : manager.getNamedBeanSet()) {
            array.add((JsonNode)this.doGet(bean, bean.getSystemName(), type, request));
        }
        return this.message(array, request.id);
    }

    @Nonnull
    protected final JsonNode doGetList(Manager<T> manager, String type, JsonNode data, Locale locale, int id) throws JsonException {
        return this.doGetList(manager, type, data, new JsonRequest(locale, "v5", "get", id));
    }

    @Nonnull
    protected abstract ObjectNode doGet(T var1, @Nonnull String var2, @Nonnull String var3, @Nonnull JsonRequest var4) throws JsonException;

    @CheckForNull
    protected abstract T getNamedBean(@Nonnull String var1, @Nonnull String var2, @Nonnull JsonNode var3, @Nonnull JsonRequest var4) throws JsonException;

    @Nonnull
    public ObjectNode getNamedBean(T bean, @Nonnull String name, @Nonnull String type, @Nonnull JsonRequest request) throws JsonException {
        if (bean == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
        }
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", bean.getSystemName());
        data.put("userName", bean.getUserName());
        data.put("comment", bean.getComment());
        ArrayNode properties = data.putArray("properties");
        bean.getPropertyKeys().stream().forEach(key -> {
            Object value = bean.getProperty((String)key);
            if (value != null) {
                properties.add((JsonNode)this.mapper.createObjectNode().put(key, value.toString()));
            } else {
                properties.add((JsonNode)this.mapper.createObjectNode().putNull(key));
            }
        });
        return this.message(type, (JsonNode)data, request.id);
    }

    @Nonnull
    protected T postNamedBean(T bean, @Nonnull JsonNode data, @Nonnull String name, @Nonnull String type, @Nonnull JsonRequest request) throws JsonException {
        if (bean == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
        }
        if (data.path("userName").isTextual()) {
            bean.setUserName(data.path("userName").asText());
        }
        if (!data.path("comment").isMissingNode()) {
            JsonNode comment = data.path("comment");
            bean.setComment(comment.isTextual() ? comment.asText() : null);
        }
        return bean;
    }
}

