/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.server.json.Bundle;
import jmri.server.json.JsonServerPreferences;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;

public class JsonServerPreferencesPanel
extends JPanel
implements PreferencesPanel {
    public static final int MAX_HEARTBEAT_INTERVAL = 3600;
    public static final int MIN_HEARTBEAT_INTERVAL = 1;
    private JSpinner heartbeatIntervalSpinner;
    private JSpinner port;
    private transient JsonServerPreferences preferences = new JsonServerPreferences();
    private JFrame parentFrame = null;

    public JsonServerPreferencesPanel() {
        this.preferences.apply(InstanceManager.getDefault(JsonServerPreferences.class));
        this.initGUI();
        this.setGUI();
    }

    public JsonServerPreferencesPanel(JFrame f) {
        this();
        this.parentFrame = f;
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JTitledSeparator(Bundle.getMessage("ServerSectionTitle")));
        this.add(this.portPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("JSONSectionTitle")));
        this.add(this.heartbeatPanel());
        this.add(Box.createVerticalGlue());
    }

    private void setGUI() {
        this.heartbeatIntervalSpinner.setValue(this.preferences.getHeartbeatInterval() / 1000);
        this.port.setValue(this.preferences.getPort());
    }

    private boolean setValues() {
        boolean didSet = true;
        this.preferences.setHeartbeatInterval((Integer)this.heartbeatIntervalSpinner.getValue() * 1000);
        this.preferences.setPort((Integer)this.port.getValue());
        return didSet;
    }

    private JPanel heartbeatPanel() {
        JPanel panel = new JPanel();
        this.heartbeatIntervalSpinner = new JSpinner(new SpinnerNumberModel(15, 1, 3600, 1));
        ((JSpinner.DefaultEditor)this.heartbeatIntervalSpinner.getEditor()).getTextField().setEditable(true);
        this.heartbeatIntervalSpinner.addChangeListener(e -> this.setValues());
        this.heartbeatIntervalSpinner.setToolTipText(Bundle.getMessage("HeartbeatToolTip", 1, 3600));
        panel.add(this.heartbeatIntervalSpinner);
        JLabel label = new JLabel(Bundle.getMessage("HeartbeatLabel"));
        label.setToolTipText(this.heartbeatIntervalSpinner.getToolTipText());
        panel.add(label);
        return panel;
    }

    private JPanel portPanel() {
        JPanel panel = new JPanel();
        this.port = new JSpinner(new SpinnerNumberModel(2056, 1, 65535, 1));
        ((JSpinner.DefaultEditor)this.port.getEditor()).getTextField().setEditable(true);
        this.port.setEditor(new JSpinner.NumberEditor(this.port, "#"));
        this.port.addChangeListener(e -> this.setValues());
        this.port.setToolTipText(Bundle.getMessage("PortToolTip"));
        panel.add(this.port);
        JLabel label = new JLabel(Bundle.getMessage("LabelPort"));
        label.setToolTipText(this.port.getToolTipText());
        panel.add(label);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return Bundle.getMessage("PreferencesItem");
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("PreferencesItemTitle");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("PreferencesTabTitle");
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return Bundle.getMessage("PreferencesTooltip");
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            InstanceManager.getDefault(JsonServerPreferences.class).apply(this.preferences);
            InstanceManager.getDefault(JsonServerPreferences.class).save();
            if (this.parentFrame != null) {
                this.parentFrame.dispose();
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.preferences.compareValuesDifferent(InstanceManager.getDefault(JsonServerPreferences.class)) || InstanceManager.getDefault(JsonServerPreferences.class).isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return InstanceManager.getDefault(JsonServerPreferences.class).isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

