/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.SocketTimeoutException;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.server.json.JsonClientHandler;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonServerPreferences;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class JsonWebSocket {
    private static final Logger log = LoggerFactory.getLogger(JsonWebSocket.class);
    private JsonConnection connection;
    private JsonClientHandler handler;
    private Runnable shutDownTask;

    @OnWebSocketConnect
    public void onOpen(Session sn) {
        log.debug("Opening connection");
        try {
            this.connection = new JsonConnection(sn);
            sn.setIdleTimeout((long)((double)InstanceManager.getDefault(JsonServerPreferences.class).getHeartbeatInterval() * 1.1));
            this.handler = new JsonClientHandler(this.connection);
            this.shutDownTask = () -> {
                try {
                    this.getConnection().sendMessage((JsonNode)this.getConnection().getObjectMapper().createObjectNode().put("type", "goodbye"), 0);
                }
                catch (IOException e) {
                    log.warn("Unable to send goodbye while closing socket.\nError was {}", (Object)e.getMessage());
                }
                this.getConnection().getSession().close();
            };
            log.debug("Sending hello");
            this.handler.onMessage("{\"type\":\"hello\"}");
        }
        catch (IOException e) {
            log.warn("Error opening WebSocket:\n{}", (Object)e.getMessage());
            sn.close();
        }
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
    }

    @OnWebSocketClose
    public void onClose(int i, String string) {
        log.debug("Closing connection because {} ({})", (Object)string, (Object)i);
        this.handler.onClose();
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    @OnWebSocketError
    public void onError(Throwable thrwbl) {
        if (thrwbl instanceof SocketTimeoutException) {
            this.connection.getSession().close(1006, thrwbl.getMessage());
        } else if (thrwbl instanceof EofException || thrwbl instanceof WebSocketException) {
            try {
                this.connection.getSession().disconnect();
            }
            catch (IOException ex) {
                this.onClose(1006, thrwbl.getMessage());
            }
        } else {
            log.error("Unanticipated error", thrwbl);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String string) {
        try {
            this.handler.onMessage(string);
        }
        catch (IOException e) {
            if (!e.getMessage().equals("Will not send message on non-open session")) {
                log.error("Error on WebSocket message:\n{}", (Object)e.getMessage());
            }
            this.connection.getSession().close();
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        }
    }

    protected JsonConnection getConnection() {
        return this.connection;
    }
}

