/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.audio;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.ProvidingManager;
import jmri.jmrit.audio.AudioSource;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.audio.Bundle;

public class JsonAudioHttpService
extends JsonNamedBeanHttpService<Audio> {
    public JsonAudioHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(Audio audio, String name, String type, JsonRequest request) throws JsonException {
        if (audio.getSubType() != 'S' || !(audio instanceof AudioSource)) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorAudioNotSource", "audio", Character.valueOf(audio.getSubType())), request.id);
        }
        AudioSource audioSource = (AudioSource)audio;
        ObjectNode root = this.getNamedBean(audio, name, this.getType(), request);
        ObjectNode data = root.with("data");
        switch (audio.getState()) {
            case 17: {
                data.put("state", 17);
                data.put("playNumLoops", audioSource.getLastNumLoops());
                break;
            }
            case 16: {
                data.put("state", 16);
                break;
            }
            default: {
                throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorInternal", type), request.id);
            }
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Audio audio, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        String command;
        if (audio.getSubType() != 'S' || !(audio instanceof AudioSource)) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorAudioNotSource", "audio", Character.valueOf(audio.getSubType())), request.id);
        }
        AudioSource audioSource = (AudioSource)audio;
        switch (command = data.path("command").asText()) {
            case "Play": {
                audioSource.play();
                break;
            }
            case "Stop": {
                audioSource.stop();
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorAudioUnknownCommand", command), request.id);
            }
        }
        return this.doGet(audio, name, type, request);
    }

    @Override
    protected void doDelete(Audio bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        this.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "audio": 
            case "audios": {
                return this.doSchema(type, server, "jmri/server/json/audio/audio-server.json", "jmri/server/json/audio/audio-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "audio";
    }

    @Override
    protected Manager<Audio> getManager() {
        return InstanceManager.getDefault(AudioManager.class);
    }

    @Override
    protected ProvidingManager<Audio> getProvidingManager() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported since AudioManager is not a ProvidingManager");
    }
}

