/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.audioicon;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import jmri.Audio;
import jmri.JmriException;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.display.AudioIcon;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.audioicon.Bundle;
import jmri.server.json.audioicon.JsonAudioIconHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAudioIconSocketService
extends JsonSocketService<JsonAudioIconHttpService> {
    private final HashMap<AudioIcon, AudioIconListener> beanListeners = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(JsonAudioIconSocketService.class);

    public JsonAudioIconSocketService(JsonConnection connection) {
        super(connection, new JsonAudioIconHttpService(connection.getObjectMapper()));
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "GetListNotAllowed", type), request.id);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        AudioIcon audioIcon;
        if (request.method.equals("get")) {
            this.connection.sendMessage(((JsonAudioIconHttpService)this.service).doGet(type, "audioicon", data, request), request.id);
        }
        if (!this.beanListeners.containsKey(audioIcon = AudioIcon.IDENTITY_MANAGER.getAudioIcon(data.get("identity").asInt()))) {
            this.addListenerToBean(audioIcon);
        }
    }

    @Override
    public void onClose() {
        this.beanListeners.values().stream().forEach(listener -> listener._audioIcon.removePropertyChangeListener((PropertyChangeListener)listener));
        this.beanListeners.clear();
    }

    protected void addListenerToBean(AudioIcon audioIcon) {
        if (audioIcon != null) {
            AudioIconListener listener = new AudioIconListener(audioIcon);
            audioIcon.addPropertyChangeListener(listener);
            this.beanListeners.put(audioIcon, listener);
        }
    }

    private class AudioIconListener
    implements PropertyChangeListener {
        public final AudioIcon _audioIcon;

        public AudioIconListener(AudioIcon audioIcon) {
            this._audioIcon = audioIcon;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("Command")) {
                return;
            }
            try {
                String command;
                int numLoops = 0;
                switch (evt.getNewValue().toString()) {
                    case "Play": {
                        command = "Play";
                        Audio audio = this._audioIcon.getAudio();
                        if (!(audio instanceof AudioSource)) break;
                        AudioSource source = (AudioSource)audio;
                        if (source.isLooped()) {
                            if (source.getMinLoops() != source.getMaxLoops()) {
                                numLoops = source.getMinLoops() + ThreadLocalRandom.current().nextInt(source.getMaxLoops() - source.getMinLoops());
                                break;
                            }
                            numLoops = source.getMinLoops();
                            break;
                        }
                        numLoops = 1;
                        break;
                    }
                    case "Stop": {
                        command = "Stop";
                        break;
                    }
                    default: {
                        log.debug("Unknown command: {}", evt.getNewValue());
                        return;
                    }
                }
                JsonRequest request = new JsonRequest(JsonAudioIconSocketService.this.getLocale(), JsonAudioIconSocketService.this.getVersion(), "get", 0);
                ObjectNode root = JsonAudioIconSocketService.this.connection.getObjectMapper().createObjectNode();
                root.put("type", "audioicon");
                root.put("method", "get");
                root.put("id", request.id);
                ObjectNode data = root.with("data");
                data.put("identity", this._audioIcon.getIdentity());
                data.put("command", command);
                data.put("playNumLoops", numLoops);
                JsonAudioIconSocketService.this.connection.sendMessage((JsonNode)root, 0);
            }
            catch (IOException ex) {
                this._audioIcon.removePropertyChangeListener(this);
                JsonAudioIconSocketService.this.beanListeners.remove(this._audioIcon);
            }
        }
    }
}

