/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.block;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.BlockManager;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProvidingManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.block.Bundle;
import jmri.server.json.idtag.JsonIdTagHttpService;
import jmri.server.json.reporter.JsonReporterHttpService;
import jmri.server.json.roster.JsonRosterHttpService;

public class JsonBlockHttpService
extends JsonNamedBeanHttpService<Block> {
    private final JsonIdTagHttpService idTagService;
    private final JsonReporterHttpService reporterService;
    private final JsonRosterHttpService rosterService;

    public JsonBlockHttpService(ObjectMapper mapper) {
        super(mapper);
        this.idTagService = new JsonIdTagHttpService(this.mapper);
        this.reporterService = new JsonReporterHttpService(this.mapper);
        this.rosterService = new JsonRosterHttpService(this.mapper);
    }

    @Override
    public ObjectNode doGet(Block block, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(block, name, this.getType(), request);
        ObjectNode data = root.with("data");
        switch (block.getState()) {
            case 1: 
            case 256: {
                data.put("state", 0);
                break;
            }
            default: {
                data.put("state", block.getState());
            }
        }
        Object bv = block.getValue();
        if (bv == null) {
            data.putNull("value");
        } else if (bv instanceof IdTag) {
            ObjectNode idTagValue = this.idTagService.doGet((IdTag)bv, name, "idTag", request);
            data.set("value", (JsonNode)idTagValue);
        } else if (bv instanceof Reporter) {
            ObjectNode reporterValue = this.reporterService.doGet((Reporter)bv, name, "reporter", request);
            data.set("value", (JsonNode)reporterValue);
        } else if (bv instanceof BasicRosterEntry) {
            ObjectNode rosterValue = (ObjectNode)this.rosterService.getRosterEntry(request.locale, ((BasicRosterEntry)bv).getId(), request.id);
            data.set("value", (JsonNode)rosterValue);
        } else {
            data.put("value", bv.toString());
        }
        Sensor sens = block.getSensor();
        data.put("sensor", sens != null ? sens.getSystemName() : null);
        Reporter rep = block.getReporter();
        data.put("reporter", rep != null ? rep.getSystemName() : null);
        data.put("speed", block.getBlockSpeed());
        data.put("curvature", block.getCurvature());
        data.put("direction", block.getDirection());
        data.put("length", block.getLengthMm());
        data.put("permissive", block.getPermissiveWorking());
        data.put("speedLimit", block.getSpeedLimit());
        ArrayNode array = data.putArray("denied");
        block.getDeniedBlocks().forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return root;
    }

    @Override
    public ObjectNode doPost(Block block, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        JsonNode node;
        if (!data.path("value").isMissingNode()) {
            if (data.path("value").isNull()) {
                block.setValue(null);
            } else {
                block.setValue(data.path("value").asText());
            }
        }
        int state = data.path("state").asInt(0);
        switch (state) {
            case 2: {
                block.setState(2);
                break;
            }
            case 4: {
                block.setState(4);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "block", state), request.id);
            }
        }
        if (!data.path("sensor").isMissingNode()) {
            node = data.path("sensor");
            if (node.isNull()) {
                block.setSensor(null);
            } else {
                Sensor sensor = InstanceManager.getDefault(SensorManager.class).getBySystemName(node.asText());
                if (sensor != null) {
                    block.setSensor(sensor.getSystemName());
                } else {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "sensor", node.asText()), request.id);
                }
            }
        }
        if (!data.path("reporter").isMissingNode()) {
            node = data.path("reporter");
            if (node.isNull()) {
                block.setReporter(null);
            } else {
                Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getBySystemName(node.asText());
                if (reporter != null) {
                    block.setReporter(reporter);
                } else {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "reporter", node.asText()), request.id);
                }
            }
        }
        String text = data.findPath("speed").asText(block.getBlockSpeed());
        try {
            block.setBlockSpeed(text);
        }
        catch (JmriException ex) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorBadPropertyValue", text, "speed", type), request.id);
        }
        block.setCurvature(data.path("curvature").asInt(block.getCurvature()));
        block.setDirection(data.path("direction").asInt(block.getDirection()));
        if (data.path("length").isNumber()) {
            block.setLength(data.path("length").floatValue());
        }
        block.setPermissiveWorking(data.path("permissive").asBoolean(block.getPermissiveWorking()));
        return this.doGet(block, name, type, request);
    }

    @Override
    protected void doDelete(Block bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        this.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "block": 
            case "blocks": {
                return this.doSchema(type, server, "jmri/server/json/block/block-server.json", "jmri/server/json/block/block-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "block";
    }

    @Override
    protected ProvidingManager<Block> getProvidingManager() {
        return InstanceManager.getDefault(BlockManager.class);
    }
}

