/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.consist;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.consisttool.ConsistFile;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.consist.Bundle;
import jmri.server.json.consist.JsonConsistManager;
import jmri.server.json.util.JsonUtilHttpService;

public class JsonConsistHttpService
extends JsonHttpService {
    final JsonConsistManager manager = InstanceManager.getOptionalDefault(JsonConsistManager.class).orElseGet(() -> InstanceManager.setDefault(JsonConsistManager.class, new JsonConsistManager()));

    public JsonConsistHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        if (!this.manager.isConsistManager()) {
            throw new JsonException(503, Bundle.getMessage(request.locale, "ErrorNoConsistManager"), request.id);
        }
        return this.getConsist(JsonUtilHttpService.addressForString(name), request);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        if (!this.manager.isConsistManager()) {
            throw new JsonException(503, Bundle.getMessage(request.locale, "ErrorNoConsistManager"), request.id);
        }
        DccLocoAddress address = data.path("address").canConvertToInt() ? new DccLocoAddress(data.path("address").asInt(), data.path("isLongAddress").asBoolean(false)) : JsonUtilHttpService.addressForString(data.path("address").asText());
        if (!this.manager.getConsistList().contains(address)) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "consist", name), request.id);
        }
        Consist consist = this.manager.getConsist(address);
        if (data.path("name").isTextual()) {
            consist.setConsistID(data.path("name").asText());
        }
        if (data.path("type").isInt()) {
            consist.setConsistType(data.path("type").asInt());
        }
        if (data.path("engines").isArray()) {
            ArrayList<DccLocoAddress> engines = new ArrayList<DccLocoAddress>();
            for (JsonNode engine : data.path("engines")) {
                DccLocoAddress engineAddress2 = new DccLocoAddress(engine.path("address").asInt(), engine.path("isLongAddress").asBoolean());
                if (!consist.contains(engineAddress2)) {
                    consist.add(engineAddress2, engine.path("forward").asBoolean());
                }
                consist.setPosition(engineAddress2, engine.path("position").asInt());
                engines.add(engineAddress2);
            }
            ArrayList<DccLocoAddress> consistEngines = new ArrayList<DccLocoAddress>(consist.getConsistList());
            consistEngines.stream().filter(engineAddress -> !engines.contains(engineAddress)).forEach(consist::remove);
        }
        try {
            new ConsistFile().writeFile(this.manager.getConsistList());
        }
        catch (IOException ex) {
            throw new JsonException(500, ex.getLocalizedMessage(), request.id);
        }
        return this.getConsist(address, request);
    }

    @Override
    public JsonNode doPut(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        if (!this.manager.isConsistManager()) {
            throw new JsonException(503, Bundle.getMessage(request.locale, "ErrorNoConsistManager"), request.id);
        }
        DccLocoAddress address = data.path("address").canConvertToInt() ? new DccLocoAddress(data.path("address").asInt(), data.path("isLongAddress").asBoolean(false)) : JsonUtilHttpService.addressForString(data.path("address").asText());
        this.manager.getConsist(address);
        return this.doPost(type, name, data, request);
    }

    @Override
    public void doDelete(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        if (!this.manager.isConsistManager()) {
            throw new JsonException(503, Bundle.getMessage(request.locale, "ErrorNoConsistManager"), request.id);
        }
        if (!this.manager.getConsistList().contains(JsonUtilHttpService.addressForString(name))) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "consist", name), request.id);
        }
        this.manager.delConsist(JsonUtilHttpService.addressForString(name));
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        if (!this.manager.isConsistManager()) {
            throw new JsonException(503, Bundle.getMessage(request.locale, "ErrorNoConsistManager"), request.id);
        }
        ArrayNode array = this.mapper.createArrayNode();
        for (LocoAddress address : this.manager.getConsistList()) {
            array.add(this.getConsist(address, request));
        }
        return this.message(array, request.id);
    }

    public JsonNode getConsist(LocoAddress address, JsonRequest request) throws JsonException {
        if (this.manager.getConsistList().contains(address)) {
            ObjectNode data = this.mapper.createObjectNode();
            Consist consist = this.manager.getConsist(address);
            data.put("address", consist.getConsistAddress().getNumber());
            data.put("isLongAddress", consist.getConsistAddress().isLongAddress());
            data.put("type", consist.getConsistType());
            ArrayNode engines = data.putArray("engines");
            consist.getConsistList().stream().forEach(locomotive -> {
                ObjectNode engine = this.mapper.createObjectNode();
                engine.put("address", locomotive.getNumber());
                engine.put("isLongAddress", locomotive.isLongAddress());
                engine.put("forward", consist.getLocoDirection((DccLocoAddress)locomotive));
                engine.put("position", consist.getPosition((DccLocoAddress)locomotive));
                engines.add((JsonNode)engine);
            });
            data.put("name", consist.getConsistID());
            data.put("sizeLimit", consist.sizeLimit());
            return this.message("consist", (JsonNode)data, request.id);
        }
        throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "consist", address.toString()), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "consist": 
            case "consists": {
                return this.doSchema(type, server, "jmri/server/json/consist/consist-server.json", "jmri/server/json/consist/consist-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }
}

