/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.layoutblock;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.layoutblock.JsonLayoutBlockHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLayoutBlockSocketService
extends JsonSocketService<JsonLayoutBlockHttpService> {
    private final HashMap<LayoutBlock, LayoutBlockListener> layoutBlockListeners = new HashMap();
    private final LayoutBlocksListener layoutBlocksListener = new LayoutBlocksListener();
    private static final Logger log = LoggerFactory.getLogger(JsonLayoutBlockSocketService.class);

    public JsonLayoutBlockSocketService(JsonConnection connection) {
        super(connection, new JsonLayoutBlockHttpService(connection.getObjectMapper()));
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        String name = data.path("name").asText();
        LayoutBlock layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(name);
        if (!request.method.equals("put") && layoutBlock != null && !layoutBlock.getSystemName().equals(name)) {
            name = layoutBlock.getSystemName();
        }
        switch (request.method) {
            case "delete": {
                ((JsonLayoutBlockHttpService)this.service).doDelete(type, name, data, request);
                break;
            }
            case "post": {
                this.connection.sendMessage(((JsonLayoutBlockHttpService)this.service).doPost(type, name, data, request), request.id);
                break;
            }
            case "put": {
                this.connection.sendMessage(((JsonLayoutBlockHttpService)this.service).doPut(type, name, data, request), request.id);
                break;
            }
            default: {
                this.connection.sendMessage(((JsonLayoutBlockHttpService)this.service).doGet(type, name, data, request), request.id);
            }
        }
        layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(name);
        if (layoutBlock != null && !this.layoutBlockListeners.containsKey(layoutBlock)) {
            LayoutBlockListener listener = new LayoutBlockListener(layoutBlock);
            layoutBlock.addPropertyChangeListener(listener);
            this.layoutBlockListeners.put(layoutBlock, listener);
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonLayoutBlockHttpService)this.service).doGetList(type, data, request), request.id);
        log.debug("adding LayoutBlocksListener");
        InstanceManager.getDefault(LayoutBlockManager.class).addPropertyChangeListener(this.layoutBlocksListener);
    }

    @Override
    public void onClose() {
        this.layoutBlockListeners.values().stream().forEach(layoutblock -> layoutblock.layoutBlock.removePropertyChangeListener((PropertyChangeListener)layoutblock));
        this.layoutBlockListeners.clear();
    }

    private class LayoutBlocksListener
    implements PropertyChangeListener {
        private LayoutBlocksListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            log.debug("in LayoutBlocksListener for '{}' ('{}' => '{}')", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            try {
                try {
                    JsonLayoutBlockSocketService.this.connection.sendMessage(((JsonLayoutBlockHttpService)JsonLayoutBlockSocketService.this.service).doGetList("layoutBlocks", (JsonNode)((JsonLayoutBlockHttpService)JsonLayoutBlockSocketService.this.service).getObjectMapper().createObjectNode(), new JsonRequest(JsonLayoutBlockSocketService.this.getLocale(), JsonLayoutBlockSocketService.this.getVersion(), "get", 0)), 0);
                    if (evt.getPropertyName().equals("length")) {
                        this.removeListenersFromRemovedBeans();
                    }
                }
                catch (JsonException ex) {
                    log.warn("json error sending LayoutBlocks: {}", (Object)ex.getJsonMessage());
                    JsonLayoutBlockSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                }
            }
            catch (IOException ex) {
                log.debug("deregistering layoutBlocksListener due to IOException");
                InstanceManager.getDefault(LayoutBlockManager.class).removePropertyChangeListener(JsonLayoutBlockSocketService.this.layoutBlocksListener);
            }
        }

        private void removeListenersFromRemovedBeans() {
            for (LayoutBlock layoutBlock : new HashSet<LayoutBlock>(JsonLayoutBlockSocketService.this.layoutBlockListeners.keySet())) {
                if (InstanceManager.getDefault(LayoutBlockManager.class).getBySystemName(layoutBlock.getSystemName()) != null) continue;
                JsonLayoutBlockSocketService.this.layoutBlockListeners.remove(layoutBlock);
            }
        }
    }

    private class LayoutBlockListener
    implements PropertyChangeListener {
        protected final LayoutBlock layoutBlock;

        public LayoutBlockListener(LayoutBlock layoutblock) {
            this.layoutBlock = layoutblock;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("redraw")) {
                log.debug("{} property '{}' changed from '{}' to '{}'", new Object[]{this.layoutBlock.getUserName(), e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                try {
                    try {
                        JsonLayoutBlockSocketService.this.connection.sendMessage(((JsonLayoutBlockHttpService)JsonLayoutBlockSocketService.this.service).doGet("layoutBlock", this.layoutBlock.getSystemName(), (JsonNode)JsonLayoutBlockSocketService.this.connection.getObjectMapper().createObjectNode(), new JsonRequest(JsonLayoutBlockSocketService.this.getLocale(), JsonLayoutBlockSocketService.this.getVersion(), "get", 0)), 0);
                    }
                    catch (JsonException ex) {
                        JsonLayoutBlockSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                    }
                }
                catch (IOException ex) {
                    this.layoutBlock.removePropertyChangeListener(this);
                    JsonLayoutBlockSocketService.this.layoutBlockListeners.remove(this.layoutBlock);
                }
            }
        }
    }
}

