/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.logixngicon;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.jmrit.display.LogixNGIcon;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.logixngicon.Bundle;

public class JsonLogixNGIconHttpService
extends JsonHttpService {
    public JsonLogixNGIconHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "GetNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        LogixNGIcon logixNGIcon;
        int identity = data.path("identity").asInt(-1);
        if (identity != -1) {
            logixNGIcon = LogixNGIcon.IDENTITY_MANAGER.getLogixNGIcon(identity);
            if (logixNGIcon == null) {
                throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
            }
        } else {
            throw new JsonException(400, Bundle.getMessage(request.locale, "InvalidIdentity", identity), request.id);
        }
        logixNGIcon.executeLogixNG();
        ObjectNode node = this.mapper.createObjectNode();
        return this.message("logixngicon", (JsonNode)node, request.id);
    }

    @Override
    public JsonNode doPut(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PutNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "logixngicon": {
                return this.doSchema(type, server, "jmri/server/json/logixngicon/logixngicon-server.json", "jmri/server/json/logixngicon/logixngicon-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    public void doDelete(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "DeleteNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "GetListNotAllowed", type), request.id);
    }
}

