/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.memory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.BasicRosterEntry;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.ProvidingManager;
import jmri.Reporter;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.idtag.JsonIdTagHttpService;
import jmri.server.json.memory.Bundle;
import jmri.server.json.reporter.JsonReporterHttpService;
import jmri.server.json.roster.JsonRosterHttpService;

public class JsonMemoryHttpService
extends JsonNamedBeanHttpService<Memory> {
    private JsonIdTagHttpService idTagService;
    private JsonReporterHttpService reporterService;
    private JsonRosterHttpService rosterService;

    public JsonMemoryHttpService(ObjectMapper mapper) {
        super(mapper);
        this.idTagService = new JsonIdTagHttpService(this.mapper);
        this.reporterService = new JsonReporterHttpService(this.mapper);
        this.rosterService = new JsonRosterHttpService(this.mapper);
    }

    @Override
    public ObjectNode doGet(Memory memory, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(memory, name, this.getType(), request);
        ObjectNode data = root.with("data");
        if (memory != null) {
            Object val = memory.getValue();
            if (val == null) {
                data.putNull("value");
            } else if (val instanceof IdTag) {
                ObjectNode idTagValue = this.idTagService.doGet((IdTag)val, name, "idTag", request);
                data.set("value", (JsonNode)idTagValue);
            } else if (val instanceof Reporter) {
                ObjectNode reporterValue = this.reporterService.doGet((Reporter)val, name, "reporter", request);
                data.set("value", (JsonNode)reporterValue);
            } else if (val instanceof BasicRosterEntry) {
                ObjectNode rosterValue = (ObjectNode)this.rosterService.getRosterEntry(request.locale, ((BasicRosterEntry)val).getId(), request.id);
                data.set("value", (JsonNode)rosterValue);
            } else {
                data.put("value", val.toString());
            }
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Memory memory, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (!data.path("value").isMissingNode()) {
            if (data.path("value").isNull()) {
                memory.setValue(null);
            } else {
                memory.setValue(data.path("value").asText());
            }
        }
        return this.doGet(memory, name, type, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "memory": 
            case "memories": {
                return this.doSchema(type, server, "jmri/server/json/memory/memory-server.json", "jmri/server/json/memory/memory-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "memory";
    }

    @Override
    protected ProvidingManager<Memory> getProvidingManager() {
        return InstanceManager.getDefault(MemoryManager.class);
    }
}

