/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.message.Bundle;
import jmri.server.json.message.JsonMessageClientManager;
import jmri.server.json.message.JsonMessageHttpService;

public class JsonMessageSocketService
extends JsonSocketService<JsonMessageHttpService> {
    public JsonMessageSocketService(JsonConnection connection) {
        super(connection, new JsonMessageHttpService(connection.getObjectMapper()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        switch (type) {
            case "hello": {
                if (data.path("client").isMissingNode()) return;
                String client = data.path("client").asText();
                if (client.isEmpty()) throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorEmptyAttribute", "client", type), request.id);
                this.subscribe(client, request.id);
                return;
            }
            case "client": {
                switch (request.method) {
                    case "delete": {
                        if (data.path("client").isMissingNode()) throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorMissingAttribute", "client", type), request.id);
                        String client = data.path("client").asText();
                        if (client.isEmpty()) throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorEmptyAttribute", "client", type), request.id);
                        this.getManager().unsubscribe(client);
                        return;
                    }
                    case "get": {
                        if (!data.path("client").isMissingNode()) {
                            String client = data.path("client").asText();
                            if (!client.isEmpty()) {
                                if (!this.getManager().getClients(this.connection).contains(client)) throw new JsonException(404, Bundle.getMessage(request.locale, "MessageClientNotForThisConnection", client), request.id);
                                this.connection.sendMessage(this.getClient(client, request), request.id);
                                return;
                            }
                            this.connection.sendMessage(this.getClient(this.getManager().getClient(this.connection), request), request.id);
                            return;
                        }
                        if (this.getManager().getClients(this.connection).isEmpty()) {
                            String client = UUID.randomUUID().toString();
                            this.subscribe(client, request.id);
                            this.connection.sendMessage(this.getClient(client, request), request.id);
                            return;
                        }
                        this.onList(type, data, request);
                        return;
                    }
                }
                if (data.path("client").isMissingNode()) throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorMissingAttribute", "client", type), request.id);
                String client = data.path("client").asText();
                if (client.isEmpty()) throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorEmptyAttribute", "client", type), request.id);
                this.subscribe(client, request.id);
                return;
            }
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        switch (type) {
            case "hello": {
                throw new JsonException(400, Bundle.getMessage(request.locale, "UnlistableService", type), request.id);
            }
            case "client": {
                Set<String> clients = this.getManager().getClients(this.connection);
                if (clients.isEmpty()) {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "NoMessageClientForThisConnection", type), request.id);
                }
                ArrayNode array = ((JsonMessageHttpService)this.service).getObjectMapper().createArrayNode();
                for (String client : clients) {
                    array.add(this.getClient(client, request));
                }
                this.connection.sendMessage(((JsonMessageHttpService)this.service).message(array, request.id), request.id);
                break;
            }
        }
    }

    @Override
    public void onClose() {
        this.getManager().unsubscribe(this.connection);
    }

    private JsonNode getClient(String client, JsonRequest request) throws JsonException {
        if (client == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "NoMessageClientForThisConnection"), request.id);
        }
        ObjectNode root = this.connection.getObjectMapper().createObjectNode();
        root.put("type", "client");
        ObjectNode data = root.putObject("data");
        data.put("client", client);
        return root;
    }

    private void subscribe(String client, int id) throws JsonException {
        try {
            this.getManager().subscribe(client, this.connection);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonException(409, Bundle.getMessage(this.connection.getLocale(), "ErrorClientConflict", "client"), id);
        }
    }

    private JsonMessageClientManager getManager() {
        return InstanceManager.getDefault(JsonMessageClientManager.class);
    }
}

