/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.oblock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.ProvidingManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.oblock.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOblockHttpService
extends JsonNamedBeanHttpService<OBlock> {
    private static final Logger log = LoggerFactory.getLogger(JsonOblockHttpService.class);

    public JsonOblockHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(OBlock oblock, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(oblock, name, this.getType(), request);
        ObjectNode data = root.with("data");
        log.debug("oblock.getState() = {}", (Object)oblock.getState());
        switch (oblock.getState()) {
            case 1: 
            case 256: {
                data.put("status", 0);
                break;
            }
            default: {
                data.put("status", oblock.getState());
            }
        }
        Sensor sens = oblock.getSensor();
        data.put("sensor", sens != null ? sens.getSystemName() : null);
        Warrant warrant = oblock.getWarrant();
        data.put("warrant", warrant != null ? warrant.getDisplayName() : null);
        data.put("train", warrant != null ? warrant.getTrainName() : null);
        return root;
    }

    @Override
    public ObjectNode doPost(OBlock oblock, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (!data.path("value").isMissingNode()) {
            if (data.path("value").isNull()) {
                oblock.setValue(null);
            } else {
                oblock.setValue(data.path("value").asText());
            }
        }
        int status = data.path("status").asInt(0);
        switch (status) {
            case 2: {
                oblock.setState(2);
                break;
            }
            case 4: {
                oblock.setState(4);
                break;
            }
            case 0: {
                break;
            }
            case 16: {
                oblock.setState(16);
                break;
            }
            case 32: {
                oblock.setState(32);
                break;
            }
            case 48: {
                oblock.setState(64);
                break;
            }
            case 64: {
                oblock.setState(128);
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "oblock", status), request.id);
            }
        }
        if (!data.path("sensor").isMissingNode()) {
            JsonNode node = data.path("sensor");
            if (node.isNull()) {
                oblock.setSensor(null);
            } else {
                Sensor sensor = InstanceManager.getDefault(SensorManager.class).getBySystemName(node.asText());
                if (sensor != null) {
                    oblock.setSensor(sensor.getSystemName());
                } else {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "sensor", node.asText()), request.id);
                }
            }
        }
        if (!data.path("train").isMissingNode()) {
            String text = data.path("train").asText(oblock.getBlockSpeed());
            oblock.getWarrant().setTrainName(text);
        }
        return this.doGet(oblock, name, type, request);
    }

    @Override
    protected void doDelete(OBlock bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        this.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "oblock": 
            case "oblocks": {
                return this.doSchema(type, server, "jmri/server/json/oblock/oblock-server.json", "jmri/server/json/oblock/oblock-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "oblock";
    }

    @Override
    protected ProvidingManager<OBlock> getProvidingManager() {
        return InstanceManager.getDefault(OBlockManager.class);
    }
}

