/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.operations.Bundle;
import jmri.server.json.operations.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOperationsHttpService
extends JsonHttpService {
    private final JsonUtil utilities;
    private static final Logger log = LoggerFactory.getLogger(JsonOperationsHttpService.class);

    public JsonOperationsHttpService(ObjectMapper mapper) {
        super(mapper);
        this.utilities = new JsonUtil(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        ObjectNode result;
        log.debug("doGet(type='{}', name='{}', data='{}')", new Object[]{type, name, data});
        Locale locale = request.locale;
        int id = request.id;
        switch (type) {
            case "car": {
                result = this.utilities.getCar(name, locale, id);
                break;
            }
            case "carType": {
                result = this.getCarType(name, locale, id);
                break;
            }
            case "engine": {
                result = this.utilities.getEngine(name, locale, id);
                break;
            }
            case "kernel": {
                Kernel kernel = InstanceManager.getDefault(KernelManager.class).getKernelByName(name);
                if (kernel == null) {
                    throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", type, name), id);
                }
                result = this.getKernel(kernel, locale, id);
                break;
            }
            case "location": {
                result = this.utilities.getLocation(name, locale, id);
                break;
            }
            case "rollingStock": {
                throw new JsonException(405, Bundle.getMessage(locale, "GetNotAllowed", type), id);
            }
            case "train": 
            case "trains": {
                type = "train";
                result = this.utilities.getTrain(name, locale, id);
                break;
            }
            case "track": {
                result = this.utilities.getTrack(this.getTrackByName(name, data, locale, id), locale);
                break;
            }
            default: {
                throw new JsonException(500, Bundle.getMessage(locale, "ErrorInternal", type), id);
            }
        }
        return this.message(type, (JsonNode)result, id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        log.debug("doPost(type='{}', name='{}', data='{}')", new Object[]{type, name, data});
        Locale locale = request.locale;
        int id = request.id;
        String newName = name;
        switch (type) {
            case "car": {
                return this.message(type, (JsonNode)this.postCar(name, data, locale, id), id);
            }
            case "carType": {
                if (data.path("rename").isTextual()) {
                    newName = data.path("rename").asText();
                    InstanceManager.getDefault(CarTypes.class).replaceName(name, newName);
                }
                return this.message(type, (JsonNode)this.getCarType(newName, locale, id).put("rename", name), id);
            }
            case "engine": {
                return this.message(type, (JsonNode)this.postEngine(name, data, locale, id), id);
            }
            case "kernel": {
                if (data.path("rename").isTextual()) {
                    newName = data.path("rename").asText();
                    InstanceManager.getDefault(KernelManager.class).replaceKernelName(name, newName);
                    InstanceManager.getDefault(KernelManager.class).deleteKernel(name);
                }
                return this.message(type, (JsonNode)this.getKernel(InstanceManager.getDefault(KernelManager.class).getKernelByName(newName), locale, id).put("rename", name), id);
            }
            case "location": {
                return this.message(type, (JsonNode)this.postLocation(name, data, locale, id), id);
            }
            case "train": {
                this.setTrain(name, data, locale, id);
                break;
            }
            case "track": {
                return this.message(type, (JsonNode)this.postTrack(name, data, locale, id), id);
            }
            case "trains": {
                break;
            }
            default: {
                throw new JsonException(405, Bundle.getMessage(locale, "PostNotAllowed", type), id);
            }
        }
        return this.doGet(type, name, data, request);
    }

    @Override
    public JsonNode doPut(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        log.debug("doPut(type='{}', name='{}', data='{}')", new Object[]{type, name, data});
        Locale locale = request.locale;
        int id = request.id;
        switch (type) {
            case "car": {
                if (data.path("road").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "road", type), id);
                }
                if (data.path("number").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "number", type), id);
                }
                String road = data.path("road").asText();
                String number = data.path("number").asText();
                if (this.carManager().getById(name) != null || this.carManager().getByRoadAndNumber(road, number) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutRollingStockConflict", type, road, number), id);
                }
                return this.message(type, (JsonNode)this.postCar(this.carManager().newRS(road, number), data, locale, id), id);
            }
            case "carType": {
                if (name.isEmpty()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "name", type), id);
                }
                InstanceManager.getDefault(CarTypes.class).addName(name);
                return this.message(type, (JsonNode)this.getCarType(name, locale, id), id);
            }
            case "engine": {
                if (data.path("road").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "road", type), id);
                }
                if (data.path("number").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "number", type), id);
                }
                String road = data.path("road").asText();
                String number = data.path("number").asText();
                if (this.engineManager().getById(name) != null || this.engineManager().getByRoadAndNumber(road, number) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutRollingStockConflict", type, road, number), id);
                }
                return this.message(type, (JsonNode)this.postEngine(this.engineManager().newRS(road, number), data, locale, id), id);
            }
            case "kernel": {
                if (name.isEmpty()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "name", type), id);
                }
                return this.message(type, (JsonNode)this.getKernel(InstanceManager.getDefault(KernelManager.class).newKernel(name), locale, id), id);
            }
            case "location": {
                if (data.path("userName").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "userName", type), id);
                }
                String userName = data.path("userName").asText();
                if (this.locationManager().getLocationById(name) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutNameConflict", type, name), id);
                }
                if (this.locationManager().getLocationByName(userName) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutUserNameConflict", type, userName), id);
                }
                return this.message(type, (JsonNode)this.postLocation(this.locationManager().newLocation(userName), data, locale, id), id);
            }
            case "track": {
                if (data.path("userName").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "userName", type), id);
                }
                String userName = data.path("userName").asText();
                if (data.path("type").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "type", type), id);
                }
                String trackType = data.path("type").asText();
                if (data.path("location").isMissingNode()) {
                    throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingPropertyPut", "location", type), id);
                }
                String locationName = data.path("location").asText();
                Location location = this.locationManager().getLocationById(locationName);
                if (location == null) {
                    throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "location", locationName), id);
                }
                if (location.getTrackById(name) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutNameConflict", type, name), id);
                }
                if (location.getTrackByName(userName, trackType) != null) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorPutUserNameConflict", type, userName), id);
                }
                return this.message(type, (JsonNode)this.postTrack(location.addTrack(userName, trackType), data, locale, id), id);
            }
        }
        return super.doPut(type, name, data, request);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        log.debug("doGetList(type='{}', data='{}')", (Object)type, (Object)data);
        Locale locale = request.locale;
        int id = request.id;
        switch (type) {
            case "car": 
            case "cars": {
                return this.message(this.getCars(locale, id), id);
            }
            case "carType": {
                return this.getCarTypes(locale, id);
            }
            case "engine": 
            case "engines": {
                return this.message(this.getEngines(locale, id), id);
            }
            case "kernel": {
                return this.getKernels(locale, id);
            }
            case "location": 
            case "locations": {
                return this.getLocations(locale, id);
            }
            case "rollingStock": {
                return this.message(this.getCars(locale, id).addAll(this.getEngines(locale, id)), id);
            }
            case "train": 
            case "trains": {
                return this.getTrains(locale, id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(locale, "ErrorInternal", type), id);
    }

    @Override
    public void doDelete(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        log.debug("doDelete(type='{}', name='{}', data='{}')", new Object[]{type, name, data});
        Locale locale = request.locale;
        int id = request.id;
        String token = data.path("forceDelete").asText();
        switch (type) {
            case "car": {
                this.deleteCar(name, locale, id);
                break;
            }
            case "carType": {
                List<Car> cars = this.carManager().getByTypeList(name);
                ArrayList locations = new ArrayList();
                this.locationManager().getList().stream().filter(l -> l.acceptsTypeName(name)).forEach(locations::add);
                if (!(cars.isEmpty() && locations.isEmpty() || this.acceptForceDeleteToken(type, name, token))) {
                    ArrayNode conflicts = this.mapper.createArrayNode();
                    cars.forEach(car -> conflicts.add((JsonNode)this.message("car", (JsonNode)this.utilities.getCar((Car)car, locale), 0)));
                    locations.forEach(location -> conflicts.add((JsonNode)this.message("location", (JsonNode)this.utilities.getLocation((Location)location, locale), 0)));
                    this.throwDeleteConflictException(type, name, conflicts, request);
                }
                InstanceManager.getDefault(CarTypes.class).deleteName(name);
                break;
            }
            case "engine": {
                this.deleteEngine(name, locale, id);
                break;
            }
            case "kernel": {
                Kernel kernel = InstanceManager.getDefault(KernelManager.class).getKernelByName(name);
                if (kernel == null) {
                    throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", type, name), id);
                }
                if (kernel.getSize() != 0 && !this.acceptForceDeleteToken(type, name, token)) {
                    this.throwDeleteConflictException(type, name, this.getKernelCars(kernel, true, locale), request);
                }
                InstanceManager.getDefault(KernelManager.class).deleteKernel(name);
                break;
            }
            case "location": {
                this.deleteLocation(name, locale, id);
                break;
            }
            case "track": {
                this.deleteTrack(name, data, locale, id);
                break;
            }
            default: {
                super.doDelete(type, name, data, request);
            }
        }
    }

    private ObjectNode getCarType(String name, Locale locale, int id) throws JsonException {
        CarTypes manager = InstanceManager.getDefault(CarTypes.class);
        if (!manager.containsName(name)) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "carType", name), id);
        }
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", name);
        ArrayNode cars = data.putArray("cars");
        this.carManager().getByTypeList(name).forEach(car -> cars.add((JsonNode)this.utilities.getCar((Car)car, locale)));
        ArrayNode locations = data.putArray("locations");
        this.locationManager().getList().stream().filter(location -> location.acceptsTypeName(name)).forEach(location -> locations.add((JsonNode)this.utilities.getLocation((Location)location, locale)));
        return data;
    }

    private JsonNode getCarTypes(Locale locale, int id) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        for (String name : InstanceManager.getDefault(CarTypes.class).getNames()) {
            array.add((JsonNode)this.message("carType", (JsonNode)this.getCarType(name, locale, id), id));
        }
        return this.message(array, id);
    }

    private ObjectNode getKernel(Kernel kernel, Locale locale, int id) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", kernel.getName());
        data.put("weight", kernel.getAdjustedWeightTons());
        data.put("length", kernel.getTotalLength());
        Car lead = (Car)kernel.getLead();
        if (lead != null) {
            data.set("lead", (JsonNode)this.utilities.getCar((Car)kernel.getLead(), locale));
        } else {
            data.putNull("lead");
        }
        data.set("cars", (JsonNode)this.getKernelCars(kernel, false, locale));
        return data;
    }

    private ArrayNode getKernelCars(Kernel kernel, boolean asMessage, Locale locale) {
        ArrayNode array = this.mapper.createArrayNode();
        kernel.getCars().forEach(car -> {
            if (asMessage) {
                array.add((JsonNode)this.message("car", (JsonNode)this.utilities.getCar((Car)car, locale), 0));
            } else {
                array.add((JsonNode)this.utilities.getCar((Car)car, locale));
            }
        });
        return array;
    }

    private JsonNode getKernels(Locale locale, int id) {
        ArrayNode array = this.mapper.createArrayNode();
        InstanceManager.getDefault(KernelManager.class).getNameList().forEach(kernel -> array.add((JsonNode)this.message("kernel", (JsonNode)this.getKernel(InstanceManager.getDefault(KernelManager.class).getKernelByName((String)kernel), locale, id * -1), id * -1)));
        return this.message(array, id);
    }

    public ArrayNode getCars(Locale locale, int id) {
        ArrayNode array = this.mapper.createArrayNode();
        this.carManager().getByIdList().forEach(car -> array.add((JsonNode)this.message("car", (JsonNode)this.utilities.getCar((Car)car, locale), id)));
        return array;
    }

    public ArrayNode getEngines(Locale locale, int id) {
        ArrayNode array = this.mapper.createArrayNode();
        this.engineManager().getByIdList().forEach(engine -> array.add((JsonNode)this.message("engine", (JsonNode)this.utilities.getEngine((Engine)engine, locale), id)));
        return array;
    }

    public JsonNode getLocations(Locale locale, int id) {
        ArrayNode array = this.mapper.createArrayNode();
        this.locationManager().getLocationsByIdList().forEach(location -> array.add((JsonNode)this.message("location", (JsonNode)this.utilities.getLocation((Location)location, locale), id)));
        return this.message(array, id);
    }

    public JsonNode getTrains(Locale locale, int id) {
        ArrayNode array = this.mapper.createArrayNode();
        this.trainManager().getTrainsByIdList().forEach(train -> array.add((JsonNode)this.message("train", (JsonNode)this.utilities.getTrain((Train)train, locale), id)));
        return this.message(array, id);
    }

    public void setTrain(String name, JsonNode data, Locale locale, int id) throws JsonException {
        Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(name);
        JsonNode location = data.path("location");
        if (!location.isMissingNode()) {
            if (location.isNull()) {
                train.terminate();
            } else if (!train.move(location.asText())) {
                throw new JsonException(428, Bundle.getMessage(locale, "ErrorTrainMovement", name, location.asText()), id);
            }
        }
    }

    public ObjectNode postLocation(String name, JsonNode data, Locale locale, int id) throws JsonException {
        return this.postLocation(this.getLocationByName(name, locale, id), data, locale, id);
    }

    public ObjectNode postLocation(Location location, JsonNode data, Locale locale, int id) throws JsonException {
        if (!data.path("reporter").isMissingNode()) {
            String name = data.path("reporter").asText();
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getBySystemName(name);
            if (reporter != null) {
                location.setReporter(reporter);
            } else {
                throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "reporter", name), id);
            }
        }
        location.setName(data.path("userName").asText(location.getName()));
        location.setComment(data.path("comment").asText(location.getCommentWithColor()));
        return this.utilities.getLocation(location, locale);
    }

    public ObjectNode postTrack(String name, JsonNode data, Locale locale, int id) throws JsonException {
        return this.postTrack(this.getTrackByName(name, data, locale, id), data, locale, id);
    }

    public ObjectNode postTrack(Track track, JsonNode data, Locale locale, int id) throws JsonException {
        if (!data.path("reporter").isMissingNode()) {
            String name = data.path("reporter").asText();
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getBySystemName(name);
            if (reporter != null) {
                track.setReporter(reporter);
            } else {
                throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "reporter", name), id);
            }
        }
        track.setName(data.path("userName").asText(track.getName()));
        track.setLength(data.path("length").asInt(track.getLength()));
        track.setComment(data.path("comment").asText(track.getComment()));
        return this.utilities.getTrack(track, locale);
    }

    public ObjectNode postCar(String name, JsonNode data, Locale locale, int id) throws JsonException {
        return this.postCar(this.getCarByName(name, locale, id), data, locale, id);
    }

    public ObjectNode postCar(@Nonnull Car car, JsonNode data, Locale locale, int id) throws JsonException {
        ObjectNode result = this.postRollingStock(car, data, locale, id);
        car.setCaboose(data.path("caboose").asBoolean(car.isCaboose()));
        car.setCarHazardous(data.path("hazardous").asBoolean(car.isHazardous()));
        car.setPassenger(data.path("passenger").asBoolean(car.isPassenger()));
        car.setFred(data.path("fred").asBoolean(car.hasFred()));
        car.setUtility(data.path("utility").asBoolean(car.isUtility()));
        return this.utilities.getCar(car, result, locale);
    }

    public ObjectNode postEngine(String name, JsonNode data, Locale locale, int id) throws JsonException {
        return this.postEngine(this.getEngineByName(name, locale, id), data, locale, id);
    }

    public ObjectNode postEngine(@Nonnull Engine engine, JsonNode data, Locale locale, int id) throws JsonException {
        engine.setModel(data.path("model").asText(engine.getModel()));
        ObjectNode result = this.postRollingStock(engine, data, locale, id);
        return this.utilities.getEngine(engine, result, locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectNode postRollingStock(@Nonnull RollingStock rs, JsonNode data, Locale locale, int id) throws JsonException {
        String status;
        Track track;
        String trackId;
        Location location;
        String name = rs.getId();
        JsonNode node = data.path("trainId");
        if (!node.isMissingNode()) {
            if (!node.isNull()) throw new JsonException(409, Bundle.getMessage(locale, "ErrorRemovingTrain", rs.getId()), id);
            if (rs.getTrain() != null) {
                rs.setTrain(null);
                rs.setDestination(null, null);
                rs.setRouteLocation(null);
                rs.setRouteDestination(null);
            }
        }
        if (!(node = data.path("location")).isMissingNode()) {
            if (rs.getTrain() != null) {
                throw new JsonException(409, Bundle.getMessage(locale, "ErrorIsOnTrain", rs.getId(), rs.getTrainName()), id);
            }
            if (!node.isNull()) {
                location = this.locationManager().getLocationById(node.path("name").asText());
                if (location == null) throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "location", node.path("name").asText()), id);
                trackId = node.path("track").path("name").asText();
                track = location.getTrackById(trackId);
                if (!trackId.isEmpty() && track == null) throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "track", trackId), id);
                status = rs.setLocation(location, track);
                if (!status.equals(Track.OKAY)) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorMovingCar", rs.getId(), "location", location.getId(), trackId, status), id);
                }
            } else {
                String status2 = rs.setLocation(null, null);
                if (!status2.equals(Track.OKAY)) {
                    throw new JsonException(409, Bundle.getMessage(locale, "ErrorMovingCar", rs.getId(), "location", null, null, status2), id);
                }
            }
        }
        if (!(node = data.path("locationUnknown")).isMissingNode()) {
            if (rs.getTrain() != null) {
                throw new JsonException(409, Bundle.getMessage(locale, "ErrorIsOnTrain", rs.getId(), rs.getTrainName()), id);
            }
            rs.setLocationUnknown(data.path("locationUnknown").asBoolean());
        }
        if (!(node = data.path("destination")).isMissingNode()) {
            location = this.locationManager().getLocationById(node.path("name").asText());
            if (location == null) throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "destination", node.path("name").asText()), id);
            trackId = node.path("track").path("name").asText();
            track = location.getTrackById(trackId);
            if (!trackId.isEmpty() && track == null) throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "track", trackId), id);
            status = rs.setDestination(location, track);
            if (!status.equals(Track.OKAY)) {
                throw new JsonException(409, Bundle.getMessage(locale, "ErrorMovingCar", rs.getId(), "destination", location.getId(), trackId, status), id);
            }
        }
        rs.setRoadName(data.path("road").asText(rs.getRoadName()));
        rs.setNumber(data.path("number").asText(rs.getNumber()));
        rs.setColor(data.path("color").asText(rs.getColor()));
        rs.setComment(data.path("comment").asText(rs.getComment()));
        rs.setOwnerName(data.path("owner").asText(rs.getOwnerName()));
        rs.setBuilt(data.path("built").asText(rs.getBuilt()));
        rs.setWeightTons(data.path("weightTons").asText());
        rs.setRfid(data.path("rfid").asText(rs.getRfid()));
        rs.setLength(Integer.toString(data.path("length").asInt(rs.getLengthInteger())));
        rs.setOutOfService(data.path("outOfService").asBoolean(rs.isOutOfService()));
        rs.setTypeName(data.path("type").asText(rs.getTypeName()));
        ObjectNode result = this.utilities.getRollingStock(rs, locale);
        if (rs.getId().equals(name)) return result;
        result.put("rename", name);
        return result;
    }

    public void deleteCar(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        this.carManager().deregister(this.getCarByName(name, locale, id));
    }

    public void deleteEngine(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        this.engineManager().deregister(this.getEngineByName(name, locale, id));
    }

    public void deleteLocation(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        this.locationManager().deregister(this.getLocationByName(name, locale, id));
    }

    public void deleteTrack(@Nonnull String name, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws JsonException {
        Track track = this.getTrackByName(name, data, locale, id);
        track.getLocation().deleteTrack(track);
    }

    @Nonnull
    protected Car getCarByName(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        Car car = (Car)this.carManager().getById(name);
        if (car == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "car", name), id);
        }
        return car;
    }

    @Nonnull
    protected Engine getEngineByName(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        Engine engine = (Engine)this.engineManager().getById(name);
        if (engine == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "engine", name), id);
        }
        return engine;
    }

    @Nonnull
    protected Location getLocationByName(@Nonnull String name, @Nonnull Locale locale, int id) throws JsonException {
        Location location = this.locationManager().getLocationById(name);
        if (location == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "location", name), id);
        }
        return location;
    }

    @Nonnull
    protected Track getTrackByName(@Nonnull String name, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws JsonException {
        if (data.path("location").isMissingNode()) {
            throw new JsonException(400, Bundle.getMessage(locale, "ErrorMissingAttribute", "location", "track"), id);
        }
        Location location = this.getLocationByName(data.path("location").asText(), locale, id);
        Track track = location.getTrackById(name);
        if (track == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "track", name), id);
        }
        return track;
    }

    protected CarManager carManager() {
        return InstanceManager.getDefault(CarManager.class);
    }

    protected EngineManager engineManager() {
        return InstanceManager.getDefault(EngineManager.class);
    }

    protected LocationManager locationManager() {
        return InstanceManager.getDefault(LocationManager.class);
    }

    protected TrainManager trainManager() {
        return InstanceManager.getDefault(TrainManager.class);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        int id = request.id;
        switch (type) {
            case "car": 
            case "cars": {
                return this.doSchema(type, server, "jmri/server/json/operations/car-server.json", "jmri/server/json/operations/car-client.json", id);
            }
            case "carType": 
            case "kernel": 
            case "rollingStock": 
            case "track": {
                return this.doSchema(type, server, "jmri/server/json/operations/" + type + "-server.json", "jmri/server/json/operations/" + type + "-client.json", id);
            }
            case "engine": 
            case "engines": {
                return this.doSchema(type, server, "jmri/server/json/operations/engine-server.json", "jmri/server/json/operations/engine-client.json", id);
            }
            case "location": 
            case "locations": {
                return this.doSchema(type, server, "jmri/server/json/operations/location-server.json", "jmri/server/json/operations/location-client.json", id);
            }
            case "train": 
            case "trains": {
                return this.doSchema(type, server, "jmri/server/json/operations/train-server.json", "jmri/server/json/operations/train-client.json", id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), id);
    }
}

