/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.operations;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.operations.JsonOperationsHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOperationsSocketService
extends JsonSocketService<JsonOperationsHttpService> {
    private final HashMap<String, BeanListener<Car>> carListeners = new HashMap();
    private final HashMap<String, BeanListener<Engine>> engineListeners = new HashMap();
    private final HashMap<String, BeanListener<Location>> locationListeners = new HashMap();
    private final HashMap<String, BeanListener<Train>> trainListeners = new HashMap();
    private final CarsListener carsListener = new CarsListener();
    private final EnginesListener enginesListener = new EnginesListener();
    private final LocationsListener locationsListener = new LocationsListener();
    private final TrainsListener trainsListener = new TrainsListener();
    private static final Logger log = LoggerFactory.getLogger(JsonOperationsSocketService.class);

    public JsonOperationsSocketService(JsonConnection connection) {
        this(connection, new JsonOperationsHttpService(connection.getObjectMapper()));
    }

    protected JsonOperationsSocketService(JsonConnection connection, JsonOperationsHttpService service) {
        super(connection, service);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        String name = data.path("name").asText();
        block6 : switch (request.method) {
            case "get": {
                this.connection.sendMessage(((JsonOperationsHttpService)this.service).doGet(type, name, data, request), request.id);
                break;
            }
            case "delete": {
                ((JsonOperationsHttpService)this.service).doDelete(type, name, data, request);
                switch (type) {
                    case "car": {
                        this.carListeners.remove(name);
                        break block6;
                    }
                    case "engine": {
                        this.engineListeners.remove(name);
                        break block6;
                    }
                    case "location": {
                        this.locationListeners.remove(name);
                        break block6;
                    }
                    case "train": {
                        this.trainListeners.remove(name);
                        break block6;
                    }
                }
                break;
            }
            case "put": {
                this.connection.sendMessage(((JsonOperationsHttpService)this.service).doPut(type, name, data, request), request.id);
                break;
            }
            default: {
                this.connection.sendMessage(((JsonOperationsHttpService)this.service).doPost(type, name, data, request), request.id);
            }
        }
        if (!request.method.equals("delete")) {
            if (request.method.equals("put") && name.isEmpty()) {
                if ("car".equals(type) || "engine".equals(type)) {
                    name = RollingStock.createId(data.path("road").asText(), data.path("number").asText());
                } else if ("location".equals(type)) {
                    name = InstanceManager.getDefault(LocationManager.class).getLocationByName(data.path("userName").asText()).getId();
                } else {
                    throw new JsonException(400, "ErrorMissingName", request.id);
                }
            }
            switch (type) {
                case "car": {
                    this.carListeners.computeIfAbsent(name, id -> {
                        CarListener l = new CarListener((String)id);
                        ((Car)InstanceManager.getDefault(CarManager.class).getById((String)id)).addPropertyChangeListener(l);
                        return l;
                    });
                    break;
                }
                case "engine": {
                    this.engineListeners.computeIfAbsent(name, id -> {
                        EngineListener l = new EngineListener((String)id);
                        ((Engine)InstanceManager.getDefault(EngineManager.class).getById((String)id)).addPropertyChangeListener(l);
                        return l;
                    });
                    break;
                }
                case "location": {
                    this.locationListeners.computeIfAbsent(name, id -> {
                        LocationListener l = new LocationListener((String)id);
                        InstanceManager.getDefault(LocationManager.class).getLocationById((String)id).addPropertyChangeListener(l);
                        return l;
                    });
                    break;
                }
                case "train": {
                    this.trainListeners.computeIfAbsent(name, id -> {
                        TrainListener l = new TrainListener((String)id);
                        InstanceManager.getDefault(TrainManager.class).getTrainById((String)id).addPropertyChangeListener(l);
                        return l;
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonOperationsHttpService)this.service).doGetList(type, data, request), request.id);
        switch (type) {
            case "car": 
            case "cars": {
                log.debug("adding CarsListener");
                InstanceManager.getDefault(CarManager.class).addPropertyChangeListener(this.carsListener);
                break;
            }
            case "engine": 
            case "engines": {
                log.debug("adding EnginesListener");
                InstanceManager.getDefault(EngineManager.class).addPropertyChangeListener(this.enginesListener);
                break;
            }
            case "location": 
            case "locations": {
                log.debug("adding LocationsListener");
                InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this.locationsListener);
                break;
            }
            case "train": 
            case "trains": {
                log.debug("adding TrainsListener");
                InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this.trainsListener);
                break;
            }
        }
    }

    @Override
    public void onClose() {
        this.carListeners.values().forEach(listener -> ((Car)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.carListeners.clear();
        this.engineListeners.values().forEach(listener -> ((Engine)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.engineListeners.clear();
        this.locationListeners.values().forEach(listener -> ((Location)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.locationListeners.clear();
        this.trainListeners.values().forEach(listener -> ((Train)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.trainListeners.clear();
        InstanceManager.getDefault(CarManager.class).removePropertyChangeListener(this.carsListener);
        InstanceManager.getDefault(EngineManager.class).removePropertyChangeListener(this.enginesListener);
        InstanceManager.getDefault(LocationManager.class).removePropertyChangeListener(this.locationsListener);
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this.trainsListener);
    }

    private class TrainsListener
    extends ManagerListener<TrainManager> {
        protected TrainsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(TrainManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("train");
        }
    }

    private class TrainListener
    extends BeanListener<Train> {
        protected TrainListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)InstanceManager.getDefault(TrainManager.class).getTrainById(id));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("train", JsonOperationsSocketService.this.trainListeners);
        }
    }

    private class LocationsListener
    extends ManagerListener<LocationManager> {
        protected LocationsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(LocationManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("location");
        }
    }

    private class LocationListener
    extends BeanListener<Location> {
        protected LocationListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)InstanceManager.getDefault(LocationManager.class).getLocationById(id));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("location", JsonOperationsSocketService.this.locationListeners);
        }
    }

    private class EnginesListener
    extends ManagerListener<EngineManager> {
        protected EnginesListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(EngineManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("engine");
        }
    }

    private class EngineListener
    extends BeanListener<Engine> {
        protected EngineListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)((Engine)InstanceManager.getDefault(EngineManager.class).getById(id)));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("engine", JsonOperationsSocketService.this.engineListeners);
        }
    }

    private class CarsListener
    extends ManagerListener<CarManager> {
        protected CarsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(CarManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("car");
        }
    }

    private class CarListener
    extends BeanListener<Car> {
        protected CarListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)((Car)InstanceManager.getDefault(CarManager.class).getById(id)));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("car", JsonOperationsSocketService.this.carListeners);
        }
    }

    protected static abstract class ManagerListener<M extends PropertyChangeProvider>
    implements PropertyChangeListener {
        protected final M manager;
        final /* synthetic */ JsonOperationsSocketService this$0;

        protected ManagerListener(M mgr) {
            this.this$0 = this$0;
            Objects.requireNonNull(mgr);
            this.manager = mgr;
        }

        protected void propertyChange(String type) {
            try {
                this.sendListChange(type);
            }
            catch (IOException ex) {
                this.manager.removePropertyChangeListener(this);
            }
        }

        private void sendListChange(String type) throws IOException {
            try {
                this.this$0.connection.sendMessage(((JsonOperationsHttpService)this.this$0.service).doGetList(type, (JsonNode)((JsonOperationsHttpService)this.this$0.service).getObjectMapper().createObjectNode(), new JsonRequest(this.this$0.getLocale(), this.this$0.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                log.warn("json error sending {}: {}", (Object)type, (Object)ex.getJsonMessage());
                this.this$0.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    protected static abstract class BeanListener<B extends Identifiable & PropertyChangeProvider>
    implements PropertyChangeListener {
        protected final B bean;
        final /* synthetic */ JsonOperationsSocketService this$0;

        protected BeanListener(B bean) {
            this.this$0 = this$0;
            this.bean = bean;
        }

        protected void propertyChange(String type, HashMap<String, BeanListener<B>> map) {
            try {
                this.sendSingleChange(type);
            }
            catch (IOException ex) {
                ((PropertyChangeProvider)this.bean).removePropertyChangeListener(this);
                map.remove(this.bean.getId());
            }
        }

        private void sendSingleChange(String type) throws IOException {
            try {
                this.this$0.connection.sendMessage(((JsonOperationsHttpService)this.this$0.service).doGet(type, this.bean.getId(), (JsonNode)this.this$0.connection.getObjectMapper().createObjectNode(), new JsonRequest(this.this$0.getLocale(), this.this$0.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                log.warn("json error sending {}: {}", (Object)type, (Object)ex.getJsonMessage());
                this.this$0.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }
}

