/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.server.json.JsonException;
import jmri.server.json.operations.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public JsonUtil(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectNode getCar(String name, Locale locale, int id) throws JsonException {
        Car car = (Car)this.carManager().getById(name);
        if (car == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "car", name), id);
        }
        return this.getCar(car, locale);
    }

    public ObjectNode getEngine(Engine engine, Locale locale) {
        return this.getEngine(engine, this.getRollingStock(engine, locale), locale);
    }

    public ObjectNode getEngine(Engine engine, ObjectNode data, Locale locale) {
        data.put("model", engine.getModel());
        data.put("hp", engine.getHp());
        data.put("consist", engine.getConsistName());
        return data;
    }

    public ObjectNode getEngine(String name, Locale locale, int id) throws JsonException {
        Engine engine = (Engine)this.engineManager().getById(name);
        if (engine == null) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "engine", name), id);
        }
        return this.getEngine(engine, locale);
    }

    public ObjectNode getCar(@Nonnull Car car, Locale locale) {
        return this.getCar(car, this.getRollingStock(car, locale), locale);
    }

    public ObjectNode getCar(@Nonnull Car car, @Nonnull ObjectNode data, Locale locale) {
        data.put("load", car.getLoadName().split("-")[0]);
        data.put("hazardous", car.isHazardous());
        data.put("caboose", car.isCaboose());
        data.put("passenger", car.isPassenger());
        data.put("fred", car.hasFred());
        data.put("setout msg", car.getDropComment());
        data.put("pickup msg", car.getPickupComment());
        data.put("kernel", car.getKernelName());
        data.put("utility", car.isUtility());
        data.put("isLocal", car.isLocalMove());
        data.put("last train", car.getLastTrainName());
        if (car.getFinalDestinationTrack() != null) {
            data.set("final dest", (JsonNode)this.getRSLocationAndTrack(car.getFinalDestinationTrack(), null, locale));
        } else if (car.getFinalDestination() != null) {
            data.set("final dest", (JsonNode)this.getRSLocation(car.getFinalDestination(), null, locale));
        } else {
            data.set("final dest", null);
        }
        if (car.getReturnWhenEmptyDestTrack() != null) {
            data.set("rwe", (JsonNode)this.getRSLocationAndTrack(car.getReturnWhenEmptyDestTrack(), null, locale));
        } else if (car.getReturnWhenEmptyDestination() != null) {
            data.set("rwe", (JsonNode)this.getRSLocation(car.getReturnWhenEmptyDestination(), null, locale));
        } else {
            data.set("rwe", null);
        }
        if (car.getReturnWhenLoadedDestTrack() != null) {
            data.set("returnWhenLoaded", (JsonNode)this.getRSLocationAndTrack(car.getReturnWhenLoadedDestTrack(), null, locale));
        } else if (car.getReturnWhenLoadedDestination() != null) {
            data.set("returnWhenLoaded", (JsonNode)this.getRSLocation(car.getReturnWhenLoadedDestination(), null, locale));
        } else {
            data.set("returnWhenLoaded", null);
        }
        data.put("division", car.getDivisionName());
        data.put("block order", car.isPassenger() ? Integer.toString(car.getBlocking()) : "");
        data.put("status", car.getStatus().replace("<", "&lt;").replace(">", "&gt;"));
        return data;
    }

    public ObjectNode getLocation(@Nonnull Location location, Locale locale) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("userName", location.getName());
        data.put("name", location.getId());
        data.put("length", location.getLength());
        data.put("comment", location.getCommentWithColor());
        Reporter reporter = location.getReporter();
        data.put("reporter", reporter != null ? reporter.getSystemName() : "");
        ArrayNode types = data.putArray("carType");
        for (String type : location.getTypeNames()) {
            types.add(type);
        }
        ArrayNode tracks = data.putArray("track");
        for (Track track : location.getTracksList()) {
            tracks.add((JsonNode)this.getTrack(track, locale));
        }
        return data;
    }

    public ObjectNode getLocation(String name, Locale locale, int id) throws JsonException {
        if (this.locationManager().getLocationById(name) == null) {
            log.error("Unable to get location id [{}].", (Object)name);
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorObject", "location", name), id);
        }
        return this.getLocation(this.locationManager().getLocationById(name), locale);
    }

    public ObjectNode getTrack(Track track, Locale locale) {
        ObjectNode node = this.mapper.createObjectNode();
        node.put("userName", track.getName());
        node.put("name", track.getId());
        node.put("comment", track.getComment());
        node.put("length", track.getLength());
        node.put("location", track.getLocation().getId());
        Reporter reporter = track.getReporter();
        node.put("reporter", reporter != null ? reporter.getSystemName() : "");
        node.put("type", track.getTrackType());
        ArrayNode types = node.putArray("carType");
        for (String type : track.getTypeNames()) {
            types.add(type);
        }
        return node;
    }

    public ObjectNode getRSLocation(@Nonnull Location location, Locale locale) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("userName", location.getName());
        data.put("name", location.getId());
        return data;
    }

    private ObjectNode getRSLocation(Location location, RouteLocation routeLocation, Locale locale) {
        ObjectNode node = this.getRSLocation(location, locale);
        if (routeLocation != null) {
            node.put("route", routeLocation.getId());
        } else {
            node.put("route", (String)null);
        }
        return node;
    }

    private ObjectNode getRSLocationAndTrack(Track track, RouteLocation routeLocation, Locale locale) {
        ObjectNode node = this.getRSLocation(track.getLocation(), routeLocation, locale);
        node.set("track", (JsonNode)this.getRSTrack(track, locale));
        return node;
    }

    public ObjectNode getRSTrack(Track track, Locale locale) {
        ObjectNode node = this.mapper.createObjectNode();
        node.put("userName", track.getName());
        node.put("name", track.getId());
        return node;
    }

    public ObjectNode getRollingStock(@Nonnull RollingStock rs, Locale locale) {
        ObjectNode node = this.mapper.createObjectNode();
        node.put("name", rs.getId());
        node.put("number", TrainCommon.splitString(rs.getNumber()));
        node.put("road", rs.getRoadName().split("-")[0]);
        node.put("rfid", rs.getRfid());
        if (!rs.getWhereLastSeenName().equals("")) {
            node.put("whereLastSeen", rs.getWhereLastSeenName() + (String)(rs.getTrackLastSeenName().equals("") ? "" : " (" + rs.getTrackLastSeenName() + ")"));
        } else {
            node.set("whereLastSeen", null);
        }
        if (!rs.getWhenLastSeenDate().equals("")) {
            node.put("whenLastSeen", rs.getWhenLastSeenDate());
        } else {
            node.set("whenLastSeen", null);
        }
        String[] type = rs.getTypeName().split("-", 2);
        node.put("type", type[0]);
        node.put("carSubType", type.length == 2 ? type[1] : "");
        node.put("length", rs.getLengthInteger());
        node.put("weight", rs.getAdjustedWeightTons());
        node.put("weightTons", rs.getWeightTons());
        node.put("color", rs.getColor());
        node.put("owner", rs.getOwnerName());
        node.put("built", rs.getBuilt());
        node.put("comment", rs.getComment());
        node.put("outOfService", rs.isOutOfService());
        node.put("locationUnknown", rs.isLocationUnknown());
        if (rs.getTrack() != null) {
            node.set("location", (JsonNode)this.getRSLocationAndTrack(rs.getTrack(), rs.getRouteLocation(), locale));
        } else if (rs.getLocation() != null) {
            node.set("location", (JsonNode)this.getRSLocation(rs.getLocation(), rs.getRouteLocation(), locale));
        } else {
            node.set("location", null);
        }
        if (rs.getTrain() != null) {
            node.put("trainId", rs.getTrain().getId());
            node.put("trainName", rs.getTrain().getName());
            node.put("trainIconName", rs.getTrain().getIconName());
        } else {
            node.set("trainId", null);
            node.set("trainName", null);
            node.set("trainIconName", null);
        }
        if (rs.getDestinationTrack() != null) {
            node.set("destination", (JsonNode)this.getRSLocationAndTrack(rs.getDestinationTrack(), rs.getRouteDestination(), locale));
        } else if (rs.getDestination() != null) {
            node.set("destination", (JsonNode)this.getRSLocation(rs.getDestination(), rs.getRouteDestination(), locale));
        } else {
            node.set("destination", null);
        }
        return node;
    }

    public ObjectNode getTrain(Train train, Locale locale) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("userName", train.getName());
        data.put("iconName", train.getIconName());
        data.put("name", train.getId());
        data.put("departureTime", train.getFormatedDepartureTime());
        data.put("description", train.getDescription());
        data.put("comment", train.getComment());
        if (train.getRoute() != null) {
            data.put("route", train.getRoute().getName());
            data.put("routeId", train.getRoute().getId());
            data.set("locations", (JsonNode)this.getRouteLocationsForTrain(train, locale));
        }
        data.set("engines", (JsonNode)this.getEnginesForTrain(train, locale));
        data.set("cars", (JsonNode)this.getCarsForTrain(train, locale));
        if (train.getTrainDepartsName() != null) {
            data.put("trainDepartsName", train.getTrainDepartsName());
        }
        if (train.getTrainTerminatesName() != null) {
            data.put("trainTerminatesName", train.getTrainTerminatesName());
        }
        data.put("location", train.getCurrentLocationName());
        if (train.getCurrentRouteLocation() != null) {
            data.put("locationId", train.getCurrentRouteLocation().getId());
        }
        data.put("status", train.getStatus(locale));
        data.put("statusCode", train.getStatusCode());
        data.put("length", train.getTrainLength());
        data.put("weight", train.getTrainWeight());
        if (train.getLeadEngine() != null) {
            data.put("leadEngine", train.getLeadEngine().toString());
        }
        data.put("caboose", train.getCabooseRoadAndNumber());
        return data;
    }

    public ObjectNode getTrain(String name, Locale locale, int id) throws JsonException {
        if (this.trainManager().getTrainById(name) == null) {
            log.error("Unable to get train id [{}].", (Object)name);
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorObject", "train", name), id);
        }
        return this.getTrain(this.trainManager().getTrainById(name), locale);
    }

    public ArrayNode getTrains(Locale locale) {
        ArrayNode array = this.mapper.createArrayNode();
        this.trainManager().getTrainsByNameList().forEach(train -> array.add((JsonNode)this.getTrain((Train)train, locale)));
        return array;
    }

    private ArrayNode getCarsForTrain(Train train, Locale locale) {
        ArrayNode array = this.mapper.createArrayNode();
        this.carManager().getByTrainDestinationList(train).forEach(car -> array.add((JsonNode)this.getCar((Car)car, locale)));
        return array;
    }

    private ArrayNode getEnginesForTrain(Train train, Locale locale) {
        ArrayNode array = this.mapper.createArrayNode();
        this.engineManager().getByTrainBlockingList(train).forEach(engine -> array.add((JsonNode)this.getEngine((Engine)engine, locale)));
        return array;
    }

    private ArrayNode getRouteLocationsForTrain(Train train, Locale locale) {
        ArrayNode array = this.mapper.createArrayNode();
        train.getRoute().getLocationsBySequenceList().forEach(route -> {
            ObjectNode root = this.mapper.createObjectNode();
            RouteLocation rl = route;
            root.put("name", rl.getId());
            root.put("userName", rl.getName());
            root.put("trainDirection", rl.getTrainDirectionString());
            root.put("comment", rl.getCommentWithColor());
            root.put("sequenceId", rl.getSequenceNumber());
            root.put("expectedArrivalTime", train.getExpectedArrivalTime(rl));
            root.put("expectedDepartureTime", train.getExpectedDepartureTime(rl));
            root.set("location", (JsonNode)this.getRSLocation(rl.getLocation(), locale));
            array.add((JsonNode)root);
        });
        return array;
    }

    private CarManager carManager() {
        return InstanceManager.getDefault(CarManager.class);
    }

    private EngineManager engineManager() {
        return InstanceManager.getDefault(EngineManager.class);
    }

    private LocationManager locationManager() {
        return InstanceManager.getDefault(LocationManager.class);
    }

    private TrainManager trainManager() {
        return InstanceManager.getDefault(TrainManager.class);
    }
}

