/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.roster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import jmri.JmriException;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.roster.Bundle;
import jmri.server.json.roster.JsonRosterHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRosterSocketService
extends JsonSocketService<JsonRosterHttpService> {
    private static final Logger log = LoggerFactory.getLogger(JsonRosterSocketService.class);
    private final JsonRosterListener rosterListener = new JsonRosterListener();
    private final JsonRosterEntryListener rosterEntryListener = new JsonRosterEntryListener();
    private final JsonRosterGroupsListener rosterGroupsListener = new JsonRosterGroupsListener();
    private boolean listening = false;

    public JsonRosterSocketService(JsonConnection connection) {
        super(connection, new JsonRosterHttpService(connection.getObjectMapper()));
    }

    public void listen() {
        if (!this.listening) {
            Roster.getDefault().addPropertyChangeListener(this.rosterListener);
            Roster.getDefault().addPropertyChangeListener(this.rosterGroupsListener);
            Roster.getDefault().getEntriesInGroup(Roster.ALLENTRIES).stream().forEach(re -> {
                re.addPropertyChangeListener(this.rosterEntryListener);
                re.addPropertyChangeListener(this.rosterGroupsListener);
            });
            this.listening = true;
        }
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        block6 : switch (request.method) {
            case "delete": {
                throw new JsonException(405, Bundle.getMessage(request.locale, "DeleteNotAllowed", type), request.id);
            }
            case "post": {
                if ("rosterEntry".equals(type)) {
                    this.connection.sendMessage(((JsonRosterHttpService)this.service).postRosterEntry(request.locale, data.path("name").asText(), data, request.id), request.id);
                    break;
                }
                throw new JsonException(501, Bundle.getMessage(request.locale, "MethodNotImplemented", request.method, type), request.id);
            }
            case "put": {
                throw new JsonException(501, Bundle.getMessage(request.locale, "MethodNotImplemented", request.method, type), request.id);
            }
            case "get": {
                switch (type) {
                    case "roster": {
                        this.connection.sendMessage(((JsonRosterHttpService)this.service).getRoster(request.locale, data, request.id), request.id);
                        break block6;
                    }
                    case "rosterEntry": {
                        this.connection.sendMessage(((JsonRosterHttpService)this.service).getRosterEntry(request.locale, data.path("name").asText(), request.id), request.id);
                        break block6;
                    }
                    case "rosterGroup": {
                        this.connection.sendMessage(((JsonRosterHttpService)this.service).getRosterGroup(request.locale, data.path("name").asText(), request.id), request.id);
                        break block6;
                    }
                    case "rosterGroups": {
                        this.connection.sendMessage(((JsonRosterHttpService)this.service).getRosterGroups(request), request.id);
                        break block6;
                    }
                }
                throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
            }
            default: {
                throw new JsonException(405, Bundle.getMessage(request.locale, "UnknownMethod", request.method), request.id);
            }
        }
        this.listen();
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonRosterHttpService)this.service).doGetList(type, data, request), request.id);
        this.listen();
    }

    @Override
    public void onClose() {
        Roster.getDefault().removePropertyChangeListener(this.rosterListener);
        Roster.getDefault().removePropertyChangeListener(this.rosterGroupsListener);
        Roster.getDefault().getEntriesInGroup(Roster.ALLENTRIES).stream().forEach(re -> {
            re.removePropertyChangeListener(this.rosterEntryListener);
            re.removePropertyChangeListener(this.rosterGroupsListener);
        });
        this.listening = false;
    }

    private class JsonRosterGroupsListener
    implements PropertyChangeListener {
        private JsonRosterGroupsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if (evt.getPropertyName().equals("RosterGroupAdded") || evt.getPropertyName().equals("RosterGroupRemoved") || evt.getPropertyName().equals("RosterGroupRenamed")) {
                    this.sendGroupsUpdate();
                } else if (evt.getPropertyName().startsWith("attributeUpdated:")) {
                    String attrName = evt.getPropertyName().substring("attributeUpdated:".length());
                    if (attrName.startsWith("RosterGroup:")) {
                        String groupName = attrName.substring("RosterGroup:".length());
                        if (Roster.getDefault().getRosterGroups().containsKey(groupName)) {
                            this.sendGroupNameUpdate(groupName);
                        }
                    }
                } else if (evt.getPropertyName().startsWith("attributeDeleted") && ((String)evt.getOldValue()).startsWith("RosterGroup:")) {
                    String groupName = ((String)evt.getOldValue()).substring("RosterGroup:".length());
                    if (Roster.getDefault().getRosterGroups().containsKey(groupName)) {
                        this.sendGroupNameUpdate(groupName);
                    }
                }
            }
            catch (IOException ex) {
                JsonRosterSocketService.this.onClose();
            }
        }

        private void sendGroupsUpdate() throws IOException {
            try {
                JsonRosterSocketService.this.connection.sendMessage(((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterGroups(new JsonRequest(JsonRosterSocketService.this.getLocale(), JsonRosterSocketService.this.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                JsonRosterSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }

        private void sendGroupNameUpdate(String groupName) throws IOException {
            try {
                log.debug("sending changed rosterGroup {} and updated group array", (Object)groupName);
                JsonRosterSocketService.this.connection.sendMessage(((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterGroup(JsonRosterSocketService.this.getLocale(), groupName, 0), 0);
                this.sendGroupsUpdate();
            }
            catch (JsonException ex) {
                JsonRosterSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    private class JsonRosterListener
    implements PropertyChangeListener {
        private JsonRosterListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.sendRosterUpdate(evt);
            }
            catch (IOException ex) {
                JsonRosterSocketService.this.onClose();
            }
        }

        private void sendRosterUpdate(PropertyChangeEvent evt) throws IOException {
            try {
                ObjectNode data = JsonRosterSocketService.this.connection.getObjectMapper().createObjectNode();
                if (evt.getPropertyName().equals("add")) {
                    data.set("add", ((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterEntry(JsonRosterSocketService.this.connection.getLocale(), (RosterEntry)evt.getNewValue(), 0));
                    ((PropertyChangeProvider)evt.getNewValue()).addPropertyChangeListener(JsonRosterSocketService.this.rosterEntryListener);
                    JsonRosterSocketService.this.connection.sendMessage((JsonNode)((JsonRosterHttpService)JsonRosterSocketService.this.service).message("roster", (JsonNode)data, 0), 0);
                } else if (evt.getPropertyName().equals("remove")) {
                    data.set("remove", ((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterEntry(JsonRosterSocketService.this.connection.getLocale(), (RosterEntry)evt.getOldValue(), 0));
                    JsonRosterSocketService.this.connection.sendMessage((JsonNode)((JsonRosterHttpService)JsonRosterSocketService.this.service).message("roster", (JsonNode)data, 0), 0);
                } else if (!(evt.getPropertyName().equals("saved") || evt.getPropertyName().equals("RosterGroupAdded") || evt.getPropertyName().equals("RosterGroupRemoved") || evt.getPropertyName().equals("RosterGroupRenamed"))) {
                    JsonRosterSocketService.this.connection.sendMessage(((JsonRosterHttpService)JsonRosterSocketService.this.service).getRoster(JsonRosterSocketService.this.connection.getLocale(), (JsonNode)NullNode.getInstance(), 0), 0);
                }
            }
            catch (JsonException ex) {
                JsonRosterSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    private class JsonRosterEntryListener
    implements PropertyChangeListener {
        private JsonRosterEntryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.sendRosterUpdate(evt);
            }
            catch (IOException ex) {
                JsonRosterSocketService.this.onClose();
            }
        }

        private void sendRosterUpdate(PropertyChangeEvent evt) throws IOException {
            try {
                if (evt.getPropertyName().equals("id")) {
                    ObjectNode data = JsonRosterSocketService.this.connection.getObjectMapper().createObjectNode();
                    RosterEntry old = new RosterEntry((RosterEntry)evt.getSource(), (String)evt.getOldValue());
                    data.set("add", ((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterEntry(JsonRosterSocketService.this.connection.getLocale(), (RosterEntry)evt.getSource(), 0));
                    data.set("remove", ((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterEntry(JsonRosterSocketService.this.connection.getLocale(), old, 0));
                    log.debug("Sending add and remove rosterEntry for {} ({} => {})", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
                    JsonRosterSocketService.this.connection.sendMessage((JsonNode)((JsonRosterHttpService)JsonRosterSocketService.this.service).message("roster", (JsonNode)data, 0), 0);
                } else if (!(evt.getPropertyName().equals("dateupdated") || evt.getPropertyName().equals("filename") || evt.getPropertyName().equals("comment"))) {
                    log.debug("Sending updated rosterEntry for {} ({} => {})", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
                    JsonRosterSocketService.this.connection.sendMessage(((JsonRosterHttpService)JsonRosterSocketService.this.service).getRosterEntry(JsonRosterSocketService.this.connection.getLocale(), (RosterEntry)evt.getSource(), 0), 0);
                }
            }
            catch (JsonException ex) {
                JsonRosterSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }
}

