/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.route;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.ProvidingManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.route.Bundle;

public class JsonRouteHttpService
extends JsonNamedBeanHttpService<Route> {
    public JsonRouteHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(Route route, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(route, name, this.getType(), request);
        ObjectNode data = root.with("data");
        if (route != null) {
            switch (route.getState()) {
                case 2: {
                    data.put("state", 2);
                    break;
                }
                case 4: {
                    data.put("state", 4);
                    break;
                }
                case 8: {
                    data.put("state", 8);
                    break;
                }
                default: {
                    data.put("state", 0);
                }
            }
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Route route, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        int state = data.path("state").asInt(0);
        switch (state) {
            case 2: 
            case 8: {
                route.setRoute();
                break;
            }
            case 0: 
            case 4: {
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "route", state), request.id);
            }
        }
        return this.doGet(route, name, type, request);
    }

    @Override
    public JsonNode doPut(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PutNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "route": 
            case "routes": {
                return this.doSchema(type, server, "jmri/server/json/route/route-server.json", "jmri/server/json/route/route-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "route";
    }

    @Override
    protected ProvidingManager<Route> getProvidingManager() {
        return InstanceManager.getDefault(RouteManager.class);
    }
}

