/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Set;
import jmri.InstanceManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.schema.Bundle;
import jmri.server.json.schema.JsonSchemaServiceCache;

public class JsonSchemaHttpService
extends JsonHttpService {
    JsonSchemaHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        Boolean server = null;
        if (data.path("server").isBoolean()) {
            server = data.path("server").asBoolean();
        }
        if (data.path("client").isBoolean()) {
            if (server == null) {
                server = !data.path("client").asBoolean();
            } else if (Boolean.TRUE.equals(server)) {
                server = null;
            }
        }
        switch (type) {
            case "schema": {
                if ("json".equals(name)) {
                    if (server != null) {
                        return this.doSchema("json", server, request);
                    }
                    return this.message(this.mapper.createArrayNode().add(this.doSchema("json", true, request)).add(this.doSchema("json", false, request)), request.id);
                }
                try {
                    ArrayNode schemas = this.mapper.createArrayNode();
                    HashSet<JsonNode> dedup = new HashSet<JsonNode>();
                    for (JsonHttpService service : InstanceManager.getDefault(JsonSchemaServiceCache.class).getServices(name, request.version)) {
                        if (server == null || server.booleanValue()) {
                            this.doSchema(schemas, dedup, service, name, true, request);
                        }
                        if (server != null && server.booleanValue()) continue;
                        this.doSchema(schemas, dedup, service, name, false, request);
                    }
                    if (schemas.size() == 1) {
                        return schemas.get(0);
                    }
                    return this.message(schemas, request.id);
                }
                catch (NullPointerException ex) {
                    throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownType", name), ex, request.id);
                }
            }
            case "type": {
                if (InstanceManager.getDefault(JsonSchemaServiceCache.class).getTypes(request.version).contains(name)) {
                    ObjectNode payload = this.mapper.createObjectNode();
                    payload.put("name", name);
                    payload.put("server", InstanceManager.getDefault(JsonSchemaServiceCache.class).getServerTypes(request.version).contains(name));
                    payload.put("client", InstanceManager.getDefault(JsonSchemaServiceCache.class).getClientTypes(request.version).contains(name));
                    return this.message("type", (JsonNode)payload, request.id);
                }
                throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
            }
        }
        throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PostNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode parameters, JsonRequest request) throws JsonException {
        if ("type".equals(type)) {
            ArrayNode array = this.mapper.createArrayNode();
            ObjectNode data = this.mapper.createObjectNode();
            for (String name : InstanceManager.getDefault(JsonSchemaServiceCache.class).getTypes(request.version)) {
                array.add(this.doGet(type, name, (JsonNode)data, request));
            }
            return this.message(array, request.id);
        }
        throw new JsonException(400, Bundle.getMessage(request.locale, "UnlistableService", type), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "json": 
            case "schema": 
            case "type": {
                return this.doSchema(type, server, "jmri/server/json/schema/" + type + "-server.json", "jmri/server/json/schema/" + type + "-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    private void doSchema(ArrayNode schemas, Set<JsonNode> dedup, JsonHttpService service, String name, boolean server, JsonRequest request) throws JsonException {
        block3: {
            try {
                JsonNode schema = service.doSchema(name, server, request);
                if (!dedup.contains(schema)) {
                    schemas.add(schema);
                    dedup.add(schema);
                }
            }
            catch (JsonException ex) {
                if (ex.getCode() == 400) break block3;
                throw ex;
            }
        }
    }
}

