/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.InstanceManagerAutoDefault;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.schema.Bundle;
import jmri.spi.JsonServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaServiceCache
implements InstanceManagerAutoDefault {
    private Map<String, Map<String, Set<JsonHttpService>>> services = new HashMap<String, Map<String, Set<JsonHttpService>>>();
    private SchemaValidatorsConfig config = new SchemaValidatorsConfig();
    private final Map<String, Set<String>> clientTypes = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> serverTypes = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, JsonSchema>> clientSchemas = new HashMap<String, Map<String, JsonSchema>>();
    private final Map<String, Map<String, JsonSchema>> serverSchemas = new HashMap<String, Map<String, JsonSchema>>();
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaServiceCache.class);

    public JsonSchemaServiceCache() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (JsonNode mapping : this.mapper.readTree(JsonSchemaServiceCache.class.getResource("/jmri/server/json/schema-map.json"))) {
                map.put(mapping.get("publicURL").asText(), mapping.get("localURL").asText());
            }
        }
        catch (IOException ex) {
            log.error("Unable to read JMRI resources for JSON schema mapping", (Throwable)ex);
        }
        this.config.setUriMappings(map);
    }

    @Nonnull
    public synchronized Set<JsonHttpService> getServices(@Nonnull String type, @Nonnull String version) {
        this.cacheServices(version);
        return this.services.get(version).getOrDefault(type, new HashSet());
    }

    @Nonnull
    public synchronized Set<String> getTypes(String version) {
        Set<String> set = this.getClientTypes(version);
        set.addAll(this.getServerTypes(version));
        return set;
    }

    @Nonnull
    public synchronized Set<String> getClientTypes(String version) {
        this.cacheServices(version);
        return new HashSet<String>((Collection)this.clientTypes.get(version));
    }

    @Nonnull
    public synchronized Set<String> getServerTypes(String version) {
        this.cacheServices(version);
        return new HashSet<String>((Collection)this.serverTypes.get(version));
    }

    @Nonnull
    public JsonSchema getClientSchema(@Nonnull String type, @Nonnull JsonRequest request) throws JsonException {
        return this.getSchema(type, false, this.clientSchemas, request);
    }

    @Nonnull
    public JsonSchema getServerSchema(@Nonnull String type, @Nonnull JsonRequest request) throws JsonException {
        return this.getSchema(type, true, this.serverSchemas, request);
    }

    private synchronized JsonSchema getSchema(@Nonnull String type, boolean server, @Nonnull Map<String, Map<String, JsonSchema>> map, @Nonnull JsonRequest request) throws JsonException {
        this.cacheServices(request.version);
        JsonSchema result = (JsonSchema)map.computeIfAbsent(request.version, v -> new HashMap()).get(type);
        if (result == null) {
            for (JsonHttpService service : this.getServices(type, request.version)) {
                log.debug("Processing {} with {}", (Object)type, (Object)service);
                result = JsonSchemaFactory.getInstance().getSchema(service.doSchema(type, server, request).path("data").path("schema"), this.config);
                if (result == null) continue;
                map.get(request.version).put(type, result);
                break;
            }
            if (result == null) {
                throw new IllegalArgumentException("type \"" + type + "\" is not a valid JSON " + (server ? "server" : "client") + " type");
            }
        }
        return result;
    }

    public void validateMessage(@Nonnull JsonNode message, boolean server, @Nonnull JsonRequest request) throws JsonException {
        log.trace("validateMessage(\"{}\", \"{}\", \"{}\", ...)", new Object[]{message, server, request});
        Map<String, Map<String, JsonSchema>> map = server ? this.serverSchemas : this.clientSchemas;
        this.validateJsonNode(message, "json", server, map, request);
        if (message.isArray()) {
            for (JsonNode item : message) {
                this.validateMessage(item, server, request);
            }
        } else {
            String type = message.path("type").asText();
            JsonNode data = message.path("data");
            if (!data.isMissingNode()) {
                if (!data.isArray()) {
                    this.validateJsonNode(data, type, server, map, request);
                } else {
                    this.validateMessage(data, server, request);
                }
            }
        }
    }

    public void validateData(@Nonnull String type, @Nonnull JsonNode data, boolean server, @Nonnull JsonRequest request) throws JsonException {
        Map<String, Map<String, JsonSchema>> map;
        log.trace("validateData(\"{}\", \"{}\", \"{}\", \"{}\", ...)", new Object[]{type, data, server, request});
        Map<String, Map<String, JsonSchema>> map2 = map = server ? this.serverSchemas : this.clientSchemas;
        if (data.isArray()) {
            for (JsonNode item : data) {
                this.validateData(type, item, server, request);
            }
        } else {
            this.validateJsonNode(data, type, server, map, request);
        }
    }

    private void validateJsonNode(@Nonnull JsonNode node, @Nonnull String type, boolean server, @Nonnull Map<String, Map<String, JsonSchema>> map, @Nonnull JsonRequest request) throws JsonException {
        log.trace("validateJsonNode(\"{}\", \"{}\", \"{}\", ...)", new Object[]{node, type, server});
        Set errors = null;
        try {
            errors = this.getSchema(type, server, map, request).validate(node);
        }
        catch (JsonException ex) {
            log.error("Unable to validate JSON schemas", (Throwable)ex);
        }
        if (errors != null && !errors.isEmpty()) {
            log.warn("Errors validating {}", (Object)node);
            errors.forEach(error -> log.warn("JSON Validation Error: {}\n\t{}\n\t{}\n\t{}", new Object[]{error.getCode(), error.getMessage(), error.getPath(), error.getType()}));
            throw new JsonException(server ? 500 : 400, Bundle.getMessage(request.locale, "LoggedError"), request.id);
        }
    }

    private void cacheServices(String version) {
        Set versionedClientTypes = this.clientTypes.computeIfAbsent(version, v -> new HashSet());
        Set versionedServerTypes = this.serverTypes.computeIfAbsent(version, v -> new HashSet());
        Map versionedServices = this.services.computeIfAbsent(version, v -> new HashMap());
        if (versionedServices.isEmpty()) {
            for (JsonServiceFactory factory : ServiceLoader.load(JsonServiceFactory.class)) {
                Set set;
                Object service = factory.getHttpService(this.mapper, "v5");
                for (String type : factory.getTypes("v5")) {
                    set = versionedServices.computeIfAbsent(type, v -> new HashSet());
                    versionedClientTypes.add(type);
                    versionedServerTypes.add(type);
                    set.add(service);
                }
                for (String type : factory.getSentTypes("v5")) {
                    set = versionedServices.computeIfAbsent(type, v -> new HashSet());
                    versionedServerTypes.add(type);
                    set.add(service);
                }
                for (String type : factory.getReceivedTypes("v5")) {
                    set = versionedServices.computeIfAbsent(type, v -> new HashSet());
                    versionedClientTypes.add(type);
                    set.add(service);
                }
            }
        }
    }
}

