/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import jmri.JmriException;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.schema.Bundle;
import jmri.server.json.schema.JsonSchemaHttpService;

public class JsonSchemaSocketService
extends JsonSocketService<JsonSchemaHttpService> {
    JsonSchemaSocketService(JsonConnection connection) {
        super(connection, new JsonSchemaHttpService(connection.getObjectMapper()));
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        switch (request.method) {
            case "delete": {
                throw new JsonException(405, Bundle.getMessage(request.locale, "DeleteNotAllowed", type), request.id);
            }
            case "post": {
                throw new JsonException(405, Bundle.getMessage(request.locale, "PostNotAllowed", type), request.id);
            }
            case "put": {
                throw new JsonException(405, Bundle.getMessage(request.locale, "PutNotAllowed", type), request.id);
            }
            case "get": {
                this.connection.sendMessage(((JsonSchemaHttpService)this.service).doGet(type, data.path("name").asText("json"), data, request), request.id);
                break;
            }
            default: {
                throw new JsonException(405, Bundle.getMessage(request.locale, "MethodNotImplemented", request.method, type), request.id);
            }
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonSchemaHttpService)this.service).doGetList(type, data, request), request.id);
    }

    @Override
    public void onClose() {
    }
}

