/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.sensor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProvidingManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.sensor.Bundle;

public class JsonSensorHttpService
extends JsonNamedBeanHttpService<Sensor> {
    public JsonSensorHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(Sensor sensor, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(sensor, name, this.getType(), request);
        ObjectNode data = root.with("data");
        data.put("inverted", sensor.getInverted());
        switch (sensor.getKnownState()) {
            case 2: {
                data.put("state", 2);
                break;
            }
            case 4: {
                data.put("state", 4);
                break;
            }
            case 8: {
                data.put("state", 8);
                break;
            }
            case 1: {
                data.put("state", 0);
                break;
            }
            default: {
                throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorInternal", type), request.id);
            }
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Sensor sensor, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (data.path("inverted").isBoolean()) {
            sensor.setInverted(data.path("inverted").asBoolean());
        }
        int state = data.path("state").asInt(0);
        try {
            switch (state) {
                case 2: {
                    sensor.setKnownState(2);
                    break;
                }
                case 4: {
                    sensor.setKnownState(4);
                    break;
                }
                case 0: 
                case 8: {
                    break;
                }
                default: {
                    throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "sensor", state), request.id);
                }
            }
        }
        catch (JmriException ex) {
            throw new JsonException(500, ex, request.id);
        }
        return this.doGet(sensor, name, type, request);
    }

    @Override
    protected void doDelete(Sensor bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        this.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "sensor": 
            case "sensors": {
                return this.doSchema(type, server, "jmri/server/json/sensor/sensor-server.json", "jmri/server/json/sensor/sensor-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "sensor";
    }

    @Override
    protected ProvidingManager<Sensor> getProvidingManager() {
        return InstanceManager.getDefault(SensorManager.class);
    }
}

