/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.signalhead;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNonProvidedNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.signalhead.Bundle;

public class JsonSignalHeadHttpService
extends JsonNonProvidedNamedBeanHttpService<SignalHead> {
    public JsonSignalHeadHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        return this.doGet(InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name), name, type, request);
    }

    @Override
    protected ObjectNode doGet(SignalHead signalHead, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(signalHead, name, type, request);
        ObjectNode data = root.with("data");
        if (signalHead != null) {
            data.put("lit", signalHead.getLit());
            data.put("appearance", signalHead.getAppearance());
            data.put("held", signalHead.getHeld());
            if (signalHead.getHeld()) {
                data.put("state", 256);
            } else {
                data.put("state", signalHead.getAppearance());
            }
            data.put("appearanceName", signalHead.getAppearanceName());
        }
        return root;
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        SignalHead signalHead = this.postNamedBean(InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name), data, name, type, request);
        if (data.path("state").isIntegralNumber()) {
            int state = data.path("state").asInt();
            if (state == 256) {
                signalHead.setHeld(true);
            } else {
                boolean isValid = false;
                for (int validState : signalHead.getValidStates()) {
                    if (state != validState) continue;
                    isValid = true;
                    if (signalHead.getHeld()) {
                        signalHead.setHeld(false);
                    }
                    signalHead.setAppearance(state);
                    break;
                }
                if (!isValid) {
                    throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "signalHead", state), request.id);
                }
            }
        }
        if (data.path("lit").isTextual()) {
            signalHead.setLit(data.path("lit").asBoolean());
        }
        if (data.path("held").isTextual()) {
            signalHead.setHeld(data.path("held").asBoolean());
        }
        return this.doGet(type, name, data, request);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        for (SignalHead head : InstanceManager.getDefault(SignalHeadManager.class).getNamedBeanSet()) {
            String name = head.getSystemName();
            array.add(this.doGet("signalHead", name, data, request));
        }
        return this.message(array, request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "signalHead": 
            case "signalHeads": {
                return this.doSchema(type, server, "jmri/server/json/signalhead/signalHead-server.json", "jmri/server/json/signalhead/signalHead-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    public SignalHead getNamedBean(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        try {
            if (!data.isEmpty() && !data.isNull()) {
                if ("put".equals(request.method)) {
                    this.doPut(type, name, data, request);
                } else if ("post".equals(request.method)) {
                    this.doPost(type, name, data, request);
                }
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidSystemName", name, type), request.id);
        }
    }
}

