/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.signalmast;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.ProvidingManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.signalmast.Bundle;

public class JsonSignalMastHttpService
extends JsonNamedBeanHttpService<SignalMast> {
    public JsonSignalMastHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(SignalMast signalMast, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(signalMast, name, this.getType(), request);
        ObjectNode data = root.with("data");
        String aspect = signalMast.getAspect();
        if (aspect == null) {
            aspect = "Unknown";
        }
        data.put("aspect", aspect);
        data.put("lit", signalMast.getLit());
        data.put("held", signalMast.getHeld());
        if (signalMast.getHeld() && signalMast.getAppearanceMap().getSpecificAppearance(0) != null) {
            data.put("state", "Held");
        } else if (!signalMast.getLit() && signalMast.getAppearanceMap().getSpecificAppearance(3) != null) {
            data.put("state", "Dark");
        } else {
            data.put("state", aspect);
        }
        return root;
    }

    @Override
    public ObjectNode doPost(SignalMast signalMast, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (data.path("state").isTextual()) {
            String aspect = data.path("state").asText();
            if (aspect.equals("Held")) {
                signalMast.setHeld(true);
            } else if (signalMast.getValidAspects().contains(aspect)) {
                String thisAspect;
                if (signalMast.getHeld()) {
                    signalMast.setHeld(false);
                }
                if ((thisAspect = signalMast.getAspect()) == null || !thisAspect.equals(aspect)) {
                    signalMast.setAspect(aspect);
                }
            } else {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "signalMast", aspect), request.id);
            }
        }
        if (data.path("lit").isTextual()) {
            signalMast.setLit(data.path("lit").asBoolean());
        }
        if (data.path("held").isTextual()) {
            signalMast.setHeld(data.path("held").asBoolean());
        }
        return this.doGet(signalMast, name, type, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "signalMast": 
            case "signalMasts": {
                return this.doSchema(type, server, "jmri/server/json/signalmast/signalMast-server.json", "jmri/server/json/signalmast/signalMast-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "signalMast";
    }

    @Override
    protected ProvidingManager<SignalMast> getProvidingManager() {
        return InstanceManager.getDefault(SignalMastManager.class);
    }
}

