/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.throttle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.server.json.JsonException;
import jmri.server.json.throttle.Bundle;
import jmri.server.json.throttle.JsonThrottleManager;
import jmri.server.json.throttle.JsonThrottleSocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonThrottle
implements ThrottleListener,
PropertyChangeListener {
    public static final String THROTTLE = "throttle";
    public static final String RELEASE = "release";
    public static final String ESTOP = "eStop";
    public static final String IDLE = "idle";
    public static final String SPEED_STEPS = "speedSteps";
    public static final String CLIENTS = "clients";
    private Throttle throttle;
    private int speedSteps = 1;
    private DccLocoAddress address = null;
    private static final Logger log = LoggerFactory.getLogger(JsonThrottle.class);

    protected JsonThrottle(DccLocoAddress address, JsonThrottleSocketService server) {
        this.address = address;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JsonThrottle getThrottle(String throttleId, JsonNode data, JsonThrottleSocketService server, int id) throws JsonException {
        JsonThrottle throttle = null;
        DccLocoAddress address = null;
        RosterEntry entry = null;
        Locale locale = server.getConnection().getLocale();
        JsonThrottleManager manager = InstanceManager.getDefault(JsonThrottleManager.class);
        if (!data.path("address").isMissingNode()) {
            if (!manager.canBeLongAddress(data.path("address").asInt()) && !manager.canBeShortAddress(data.path("address").asInt())) {
                log.warn("Address \"{}\" is not a valid address.", (Object)data.path("address").asInt());
                throw new JsonException(400, Bundle.getMessage(locale, "ErrorThrottleInvalidAddress", data.path("address").asInt()), id);
            }
            address = new DccLocoAddress(data.path("address").asInt(), data.path("isLongAddress").asBoolean(!manager.canBeShortAddress(data.path("address").asInt())));
        } else {
            if (data.path("rosterEntry").isMissingNode()) {
                log.warn("No address specified");
                throw new JsonException(400, Bundle.getMessage(locale, "ErrorThrottleNoAddress"), id);
            }
            entry = Roster.getDefault().getEntryForId(data.path("rosterEntry").asText());
            if (entry == null) {
                log.warn("Roster entry \"{}\" does not exist.", (Object)data.path("rosterEntry").asText());
                throw new JsonException(404, Bundle.getMessage(locale, "ErrorThrottleRosterEntry", data.path("rosterEntry").asText()), id);
            }
            address = entry.getDccLocoAddress();
        }
        if (manager.containsKey(address)) {
            throttle = manager.get(address);
            manager.put(throttle, server);
            throttle.sendMessage(server.getConnection().getObjectMapper().createObjectNode().put(CLIENTS, manager.getServers(throttle).size()));
            return throttle;
        }
        throttle = new JsonThrottle(address, server);
        if (entry != null) {
            if (!manager.requestThrottle(entry, (ThrottleListener)throttle)) {
                log.error("Unable to get rostered throttle for \"{}\".", (Object)entry.getId());
                throw new JsonException(500, Bundle.getMessage(server.getConnection().getLocale(), "ErrorThrottleUnableToGetThrottle", entry.getId()), id);
            }
        } else if (!manager.requestThrottle(address, (ThrottleListener)throttle)) {
            log.error("Unable to get throttle for \"{}\".", (Object)address);
            throw new JsonException(500, Bundle.getMessage(server.getConnection().getLocale(), "ErrorThrottleUnableToGetThrottle", address), id);
        }
        manager.put(address, throttle);
        manager.put(throttle, server);
        return throttle;
    }

    public void close(JsonThrottleSocketService server, boolean notifyClient) {
        if (this.throttle != null) {
            List<JsonThrottleSocketService> servers = InstanceManager.getDefault(JsonThrottleManager.class).getServers(this);
            if (servers.size() == 1 && servers.get(0).equals(server)) {
                this.throttle.setSpeedSetting(0.0f);
            }
            this.release(server, notifyClient);
        }
    }

    public void release(JsonThrottleSocketService server, boolean notifyClient) {
        JsonThrottleManager manager = InstanceManager.getDefault(JsonThrottleManager.class);
        ObjectMapper mapper = server.getConnection().getObjectMapper();
        if (this.throttle != null) {
            if (manager.getServers(this).size() == 1) {
                this.throttle.release(this);
                this.throttle.removePropertyChangeListener(this);
                this.throttle = null;
            }
            if (notifyClient) {
                this.sendMessage(mapper.createObjectNode().putNull(RELEASE), server);
            }
        }
        manager.remove(this, server);
        if (manager.getServers(this).isEmpty()) {
            manager.remove(this.address);
        } else {
            this.sendMessage(mapper.createObjectNode().put(CLIENTS, manager.getServers(this).size()));
        }
    }

    public void onMessage(Locale locale, JsonNode data, JsonThrottleSocketService server) {
        data.fields().forEachRemaining(entry -> {
            String k = (String)entry.getKey();
            JsonNode v = (JsonNode)entry.getValue();
            switch (k) {
                case "eStop": {
                    this.throttle.setSpeedSetting(-1.0f);
                    return;
                }
                case "idle": {
                    this.throttle.setSpeedSetting(0.0f);
                    break;
                }
                case "speed": {
                    this.throttle.setSpeedSetting((float)v.asDouble());
                    break;
                }
                case "forward": {
                    this.throttle.setIsForward(v.asBoolean());
                    break;
                }
                case "release": {
                    server.release(this);
                    break;
                }
                case "status": {
                    this.sendStatus(server);
                    break;
                }
                case "address": 
                case "name": 
                case "throttle": 
                case "rosterEntry": {
                    break;
                }
                default: {
                    for (int i = 0; i < this.throttle.getFunctions().length; ++i) {
                        if (!k.equals(Throttle.getFunctionString(i))) continue;
                        this.throttle.setFunction(i, v.asBoolean());
                        break;
                    }
                    log.debug("Unknown field \"{}\": \"{}\"", (Object)k, (Object)v);
                }
            }
        });
    }

    public void sendMessage(ObjectNode data) {
        new ArrayList<JsonThrottleSocketService>(InstanceManager.getDefault(JsonThrottleManager.class).getServers(this)).stream().forEach(server -> this.sendMessage(data, (JsonThrottleSocketService)server));
    }

    public void sendMessage(ObjectNode data, JsonThrottleSocketService server) {
        try {
            server.sendMessage(this, data.deepCopy());
        }
        catch (IOException ex) {
            this.close(server, false);
            log.warn("Unable to send message, closing connection: {}", (Object)ex.getMessage());
            try {
                server.getConnection().close();
            }
            catch (IOException e1) {
                log.warn("Unable to close connection.", (Throwable)e1);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ObjectNode data = InstanceManager.getDefault(JsonThrottleManager.class).getObjectMapper().createObjectNode();
        String property = evt.getPropertyName();
        if (property.equals("SpeedSetting")) {
            data.put("speed", ((Number)evt.getNewValue()).floatValue());
        } else if (property.equals("IsForward")) {
            data.put("forward", (Boolean)evt.getNewValue());
        } else if (property.startsWith("F") && !property.contains("Momentary")) {
            data.put(property, (Boolean)evt.getNewValue());
        }
        if (data.size() > 0) {
            this.sendMessage(data);
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle throttle) {
        log.debug("Found throttle {}", (Object)throttle.getLocoAddress());
        this.throttle = throttle;
        throttle.addPropertyChangeListener(this);
        this.speedSteps = throttle.getSpeedStepMode().numSteps;
        this.sendStatus();
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        JsonThrottleManager manager = InstanceManager.getDefault(JsonThrottleManager.class);
        for (JsonThrottleSocketService server : manager.getServers(this).toArray(new JsonThrottleSocketService[manager.getServers(this).size()])) {
            this.sendErrorMessage(new JsonException(512, Bundle.getMessage(server.getConnection().getLocale(), "ErrorThrottleRequestFailed", address, reason), 0), server);
            server.release(this);
        }
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    private void sendErrorMessage(JsonException message, JsonThrottleSocketService server) {
        try {
            server.getConnection().sendMessage(message.getJsonMessage(), message.getId());
        }
        catch (IOException e) {
            log.warn("Unable to send message, closing connection. ", (Throwable)e);
            try {
                server.getConnection().close();
            }
            catch (IOException e1) {
                log.warn("Unable to close connection.", (Throwable)e1);
            }
        }
    }

    private void sendStatus() {
        if (this.throttle != null) {
            this.sendMessage(this.getStatus());
        }
    }

    protected void sendStatus(JsonThrottleSocketService server) {
        if (this.throttle != null) {
            this.sendMessage(this.getStatus(), server);
        }
    }

    private ObjectNode getStatus() {
        ObjectNode data = InstanceManager.getDefault(JsonThrottleManager.class).getObjectMapper().createObjectNode();
        data.put("address", this.throttle.getLocoAddress().getNumber());
        data.put("speed", this.throttle.getSpeedSetting());
        data.put("forward", this.throttle.getIsForward());
        for (int i = 0; i < this.throttle.getFunctions().length; ++i) {
            data.put(Throttle.getFunctionString(i), this.throttle.getFunction(i));
        }
        data.put(SPEED_STEPS, this.speedSteps);
        data.put(CLIENTS, InstanceManager.getDefault(JsonThrottleManager.class).getServers(this).size());
        if (this.throttle.getRosterEntry() != null) {
            data.put("rosterEntry", this.throttle.getRosterEntry().getId());
        }
        return data;
    }

    Throttle getThrottle() {
        return this.throttle;
    }
}

