/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.throttle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import jmri.JmriException;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.throttle.Bundle;
import jmri.server.json.throttle.JsonThrottle;
import jmri.server.json.throttle.JsonThrottleHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonThrottleSocketService
extends JsonSocketService<JsonThrottleHttpService> {
    private final HashMap<String, JsonThrottle> throttles = new HashMap();
    private final HashMap<JsonThrottle, String> throttleIds = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(JsonThrottleSocketService.class);

    public JsonThrottleSocketService(JsonConnection connection) {
        super(connection, new JsonThrottleHttpService(connection.getObjectMapper()));
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        log.debug("Processing {}", (Object)data);
        String name = data.path("name").asText();
        if (name.isEmpty()) {
            name = data.path("throttle").asText();
            log.warn("JSON throttle \"{}\" requested using \"throttle\" instead of \"name\"", (Object)name);
        }
        if (name.isEmpty()) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorThrottleId"), request.id);
        }
        JsonThrottle throttle = this.throttles.get(name);
        if (!this.throttles.containsKey(name)) {
            throttle = JsonThrottle.getThrottle(name, data, this, request.id);
            this.throttles.put(name, throttle);
            this.throttleIds.put(throttle, name);
            throttle.sendStatus(this);
        }
        throttle.onMessage(request.locale, data, this);
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(400, Bundle.getMessage(request.locale, "UnlistableService", type), request.id);
    }

    @Override
    public void onClose() {
        new HashSet<String>(this.throttles.keySet()).stream().forEach(throttleId -> {
            this.throttles.get(throttleId).close(this, false);
            this.throttles.remove(throttleId);
        });
        this.throttleIds.clear();
    }

    void release(JsonThrottle throttle) {
        throttle.release(this, true);
        this.throttles.remove(this.throttleIds.get(throttle));
        this.throttleIds.remove(throttle);
    }

    public void sendMessage(JsonThrottle throttle, ObjectNode data) throws IOException {
        String id = this.throttleIds.get(throttle);
        if (id != null) {
            data.put("name", id);
            data.put("throttle", id);
            this.connection.sendMessage((JsonNode)((JsonThrottleHttpService)this.service).message("throttle", (JsonNode)data, 0), 0);
        }
    }
}

