/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.Metadata;
import jmri.SystemConnectionMemo;
import jmri.Version;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.server.json.JSON;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonServerPreferences;
import jmri.server.json.util.Bundle;
import jmri.util.node.NodeIdentity;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceManager;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtilHttpService
extends JsonHttpService {
    private static final String RESOURCE_PATH = "jmri/server/json/util/";
    private static final Logger log = LoggerFactory.getLogger(JsonUtilHttpService.class);

    public JsonUtilHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, @CheckForNull String name, JsonNode data, JsonRequest request) throws JsonException {
        switch (type) {
            case "hello": {
                return this.getHello(InstanceManager.getDefault(JsonServerPreferences.class).getHeartbeatInterval(), request);
            }
            case "metadata": {
                if (name == null) {
                    return this.getMetadata(request);
                }
                return this.getMetadata(request.locale, name, request.id);
            }
            case "networkService": 
            case "networkServices": {
                if (name == null) {
                    return this.getNetworkServices(request.locale, request.id);
                }
                return this.getNetworkService(name, request);
            }
            case "node": {
                return this.getNode(request);
            }
            case "panel": 
            case "panels": {
                if (name == null) {
                    return this.getPanels(request.id);
                }
                return this.getPanel(request.locale, name, request.id);
            }
            case "railroad": {
                return this.getRailroad(request);
            }
            case "systemConnection": 
            case "systemConnections": {
                if (name == null) {
                    return this.getSystemConnections(request);
                }
                return this.getSystemConnection(name, request);
            }
            case "configProfile": 
            case "configProfiles": {
                if (name == null) {
                    return this.getConfigProfiles(request);
                }
                return this.getConfigProfile(name, request);
            }
            case "version": {
                return this.getVersion();
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    public ArrayNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        switch (type) {
            case "metadata": {
                return this.getMetadata(request);
            }
            case "networkService": 
            case "networkServices": {
                return this.getNetworkServices(request);
            }
            case "panel": 
            case "panels": {
                return this.getPanels(request.id);
            }
            case "systemConnection": 
            case "systemConnections": {
                return this.getSystemConnections(request);
            }
            case "configProfile": 
            case "configProfiles": {
                return this.getConfigProfiles(request);
            }
        }
        ArrayNode array = this.mapper.createArrayNode();
        JsonNode node = this.doGet(type, null, data, request);
        if (node.isArray()) {
            array.addAll((ArrayNode)node);
        } else {
            array.add(node);
        }
        return array;
    }

    @Override
    public JsonNode doPost(String type, @CheckForNull String name, JsonNode data, JsonRequest request) throws JsonException {
        log.debug("doPost(type='{}', name='{}', data='{}')", new Object[]{type, name, data});
        switch (type) {
            case "railroad": {
                InstanceManager.getDefault(WebServerPreferences.class).setRailroadName(name);
                break;
            }
            default: {
                log.debug("Received unexpected POST command: '{}'", (Object)type);
            }
        }
        return this.doGet(type, name, data, request);
    }

    public JsonNode getVersion() throws JsonException {
        ObjectNode data = this.mapper.createObjectNode();
        for (String version : JSON.VERSIONS) {
            try {
                Field field = JSON.class.getDeclaredField(version.toUpperCase() + "_PROTOCOL_VERSION");
                data.put(field.get(null).toString(), version);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                throw new JsonException(500, ex, 0);
            }
        }
        return this.message("version", (JsonNode)data, 0);
    }

    public JsonNode getHello(int heartbeat, @Nonnull JsonRequest request) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("JMRI", Version.name());
        data.put("json", "5.4.0");
        data.put("version", "v5");
        data.put("heartbeat", Math.round((float)heartbeat * 0.9f));
        data.put("railroad", InstanceManager.getDefault(WebServerPreferences.class).getRailroadName());
        data.put("node", NodeIdentity.networkIdentity());
        Profile activeProfile = ProfileManager.getDefault().getActiveProfile();
        data.put("activeProfile", activeProfile != null ? activeProfile.getName() : null);
        return this.message("hello", (JsonNode)data, request.id);
    }

    public JsonNode getMetadata(@Nonnull String name, @Nonnull JsonRequest request) throws JsonException {
        String metadata = Metadata.getBySystemName(name);
        ObjectNode data = this.mapper.createObjectNode();
        if (metadata == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "metadata", name), request.id);
        }
        data.put("name", name);
        data.put("value", Metadata.getBySystemName(name));
        return this.message("metadata", (JsonNode)data, request.id);
    }

    public JsonNode getMetadata(Locale locale, String name, int id) throws JsonException {
        return this.getMetadata(name, new JsonRequest(locale, "v5", "get", id));
    }

    public ArrayNode getMetadata(@Nonnull JsonRequest request) throws JsonException {
        ArrayNode root = this.mapper.createArrayNode();
        for (String name : Metadata.getSystemNameList()) {
            root.add(this.getMetadata(name, request));
        }
        return root;
    }

    public JsonNode getNetworkService(@Nonnull String name, @Nonnull JsonRequest request) throws JsonException {
        for (ZeroConfService service : InstanceManager.getDefault(ZeroConfServiceManager.class).allServices()) {
            if (!service.getType().equals(name)) continue;
            return this.getNetworkService(service, request.id);
        }
        throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "networkService", name), request.id);
    }

    private JsonNode getNetworkService(ZeroConfService service, int id) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", service.getType());
        data.put("userName", service.getName());
        data.put("port", service.getServiceInfo().getPort());
        data.put("type", service.getType());
        Enumeration pe = service.getServiceInfo().getPropertyNames();
        while (pe.hasMoreElements()) {
            String pn = (String)pe.nextElement();
            data.put(pn, service.getServiceInfo().getPropertyString(pn));
        }
        return this.message("networkService", (JsonNode)data, id);
    }

    public ArrayNode getNetworkServices(@Nonnull JsonRequest request) {
        ArrayNode root = this.mapper.createArrayNode();
        InstanceManager.getDefault(ZeroConfServiceManager.class).allServices().stream().forEach(service -> root.add(this.getNetworkService((ZeroConfService)service, request.id)));
        return root;
    }

    public ArrayNode getNetworkServices(Locale locale, int id) {
        return this.getNetworkServices(new JsonRequest(locale, "v5", "get", id));
    }

    public JsonNode getNode(JsonRequest request) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("node", NodeIdentity.networkIdentity());
        ArrayNode nodes = this.mapper.createArrayNode();
        NodeIdentity.formerIdentities().stream().forEach(arg_0 -> ((ArrayNode)nodes).add(arg_0));
        data.set("formerNodes", (JsonNode)nodes);
        return this.message("node", (JsonNode)data, request.id);
    }

    public JsonNode getPanel(Locale locale, String name, int id) throws JsonException {
        ArrayNode panels = this.getPanels("xml", id);
        for (JsonNode panel : panels) {
            if (!panel.path("data").path("name").asText().equals(name)) continue;
            return this.message("panel", panel.path("data"), id);
        }
        throw new JsonException(404, Bundle.getMessage(locale, "ErrorObject", "panel", name), id);
    }

    public ObjectNode getPanel(Editor editor, String format, int id) {
        String title;
        JFrame frame;
        if (editor.getAllowInFrameServlet() && (frame = editor.getTargetFrame()) != null && !(title = frame.getTitle()).isEmpty() && !Arrays.asList(InstanceManager.getDefault(WebServerPreferences.class).getDisallowedFrames()).contains(title)) {
            String type = "Panel";
            String name = "Panel";
            if (editor instanceof ControlPanelEditor) {
                type = "Control Panel";
                name = "ControlPanel";
            } else if (editor instanceof LayoutEditor) {
                type = "Layout";
                name = "Layout";
            } else if (editor instanceof SwitchboardEditor) {
                type = "Switchboard";
                name = "Switchboard";
            }
            ObjectNode data = this.mapper.createObjectNode();
            data.put("name", name + "/" + title.replace(" ", "%20").replace("#", "%23"));
            data.put("URL", "/panel/" + data.path("name").asText() + "?format=" + format);
            data.put("userName", title);
            data.put("type", type);
            return this.message("panel", (JsonNode)data, id);
        }
        return null;
    }

    public ArrayNode getPanels(String format, int id) {
        ArrayNode root = this.mapper.createArrayNode();
        InstanceManager.getDefault(EditorManager.class).getAll().stream().map(editor -> this.getPanel((Editor)editor, format, id)).filter(Objects::nonNull).forEach(arg_0 -> ((ArrayNode)root).add(arg_0));
        return root;
    }

    public ArrayNode getPanels(int id) {
        return this.getPanels("xml", id);
    }

    public JsonNode getRailroad(@Nonnull JsonRequest request) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", InstanceManager.getDefault(WebServerPreferences.class).getRailroadName());
        return this.message("railroad", (JsonNode)data, request.id);
    }

    public JsonNode getSystemConnection(String name, JsonRequest request) throws JsonException {
        for (JsonNode connection : this.getSystemConnections(request)) {
            JsonNode data = connection.path("data");
            if (!data.path("name").asText().equals(name)) continue;
            return this.message("systemConnection", data, request.id);
        }
        throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "systemConnection", name), request.id);
    }

    public ArrayNode getSystemConnections(@Nonnull JsonRequest request) {
        ArrayNode root = this.mapper.createArrayNode();
        ArrayList<String> prefixes = new ArrayList<String>();
        for (ConnectionConfig config : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (config.getDisabled()) continue;
            ObjectNode data = this.mapper.createObjectNode();
            data.put("name", config.getConnectionName());
            data.put("prefix", config.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            data.put("mfg", config.getManufacturer());
            data.put("description", Bundle.getMessage(request.locale, "ConnectionSucceeded", config.getConnectionName(), config.name(), config.getInfo()));
            prefixes.add(config.getAdapter().getSystemConnectionMemo().getSystemPrefix());
            root.add((JsonNode)this.message("systemConnection", (JsonNode)data, request.id));
        }
        InstanceManager.getList(SystemConnectionMemo.class).stream().map(instance -> instance).filter(memo -> !memo.getDisabled() && !prefixes.contains(memo.getSystemPrefix())).forEach(memo -> {
            ObjectNode data = this.mapper.createObjectNode();
            data.put("name", memo.getUserName());
            data.put("prefix", memo.getSystemPrefix());
            data.putNull("mfg");
            data.putNull("description");
            prefixes.add(memo.getSystemPrefix());
            root.add((JsonNode)this.message("systemConnection", (JsonNode)data, request.id));
        });
        SystemConnectionMemo internal = InstanceManager.getDefault(InternalSystemConnectionMemo.class);
        if (!prefixes.contains(internal.getSystemPrefix())) {
            ObjectNode data = this.mapper.createObjectNode();
            data.put("name", internal.getUserName());
            data.put("prefix", internal.getSystemPrefix());
            data.putNull("mfg");
            data.putNull("description");
            root.add((JsonNode)this.message("systemConnection", (JsonNode)data, request.id));
        }
        return root;
    }

    private JsonNode getConfigProfile(@Nonnull Profile profile, @Nonnull ProfileManager manager, @Nonnull JsonRequest request) {
        boolean active = profile == manager.getActiveProfile();
        boolean next = profile == manager.getNextActiveProfile();
        boolean isAutoStart = active && manager.isAutoStartActiveProfile();
        ObjectNode data = this.mapper.createObjectNode();
        data.put("userName", profile.getName());
        data.put("uniqueId", profile.getUniqueId());
        data.put("name", profile.getId());
        data.put("isActiveProfile", active);
        if (request.version.equals("v5")) {
            data.put("isAutoStart", isAutoStart);
        }
        data.put("isNextProfile", next);
        return this.message("configProfile", (JsonNode)data, request.id);
    }

    public JsonNode getConfigProfile(@Nonnull String name, @Nonnull JsonRequest request) throws JsonException {
        ProfileManager manager = ProfileManager.getDefault();
        for (Profile profile : manager.getProfiles()) {
            if (!profile.getId().equals(name)) continue;
            return this.getConfigProfile(profile, manager, request);
        }
        throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorObject", "configProfile", name), request.id);
    }

    public ArrayNode getConfigProfiles(@Nonnull JsonRequest request) {
        ArrayNode root = this.mapper.createArrayNode();
        ProfileManager manager = ProfileManager.getDefault();
        for (Profile profile : manager.getProfiles()) {
            if (profile == null) continue;
            root.add(this.getConfigProfile(profile, manager, request));
        }
        return root;
    }

    public static DccLocoAddress addressForString(String address) {
        String[] components = address.split("[()]");
        int number = Integer.parseInt(components[0]);
        boolean isLong = false;
        if (components.length > 1 && "L".equalsIgnoreCase(components[1])) {
            isLong = true;
        }
        return new DccLocoAddress(number, isLong);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        int id = request.id;
        try {
            switch (type) {
                case "configProfile": 
                case "configProfiles": {
                    return this.doSchema(type, server, "jmri/server/json/util/configProfile-server.json", "jmri/server/json/util/configProfile-client.json", id);
                }
                case "networkService": 
                case "networkServices": {
                    return this.doSchema(type, server, "jmri/server/json/util/networkService-server.json", "jmri/server/json/util/networkService-client.json", id);
                }
                case "panel": 
                case "panels": {
                    return this.doSchema(type, server, "jmri/server/json/util/panel-server.json", "jmri/server/json/util/panel-client.json", id);
                }
                case "systemConnection": 
                case "systemConnections": {
                    return this.doSchema(type, server, "jmri/server/json/util/systemConnection-server.json", "jmri/server/json/util/systemConnection-client.json", id);
                }
                case "error": 
                case "list": 
                case "pong": {
                    if (server) {
                        return this.doSchema(type, server, this.mapper.readTree(this.getClass().getClassLoader().getResource(RESOURCE_PATH + type + "-server.json")), id);
                    }
                    throw new JsonException(400, Bundle.getMessage(request.locale, "NotAClientType", type), id);
                }
                case "locale": 
                case "ping": {
                    if (!server) {
                        return this.doSchema(type, server, this.mapper.readTree(this.getClass().getClassLoader().getResource(RESOURCE_PATH + type + "-client.json")), id);
                    }
                    throw new JsonException(400, Bundle.getMessage(request.locale, "NotAServerType", type), id);
                }
                case "goodbye": 
                case "hello": 
                case "metadata": 
                case "node": 
                case "railroad": 
                case "version": {
                    return this.doSchema(type, server, RESOURCE_PATH + type + "-server.json", RESOURCE_PATH + type + "-client.json", id);
                }
            }
            throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), id);
        }
        catch (IOException ex) {
            throw new JsonException(500, ex, id);
        }
    }
}

