/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.web.app;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import jmri.InstanceManager;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.server.web.spi.WebManifest;
import jmri.server.web.spi.WebMenuItem;
import jmri.util.FileUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import jmri.web.server.WebServer;
import jmri.web.server.WebServerPreferences;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppManager
extends AbstractPreferencesManager {
    private final HashMap<Profile, WatchService> watcher = new HashMap();
    private final Map<WatchKey, Path> watchPaths = new HashMap<WatchKey, Path>();
    private final HashMap<Profile, List<WebManifest>> manifests = new HashMap();
    private Thread lifeCycleListener = null;
    private static final Logger log = LoggerFactory.getLogger(WebAppManager.class);

    @Override
    public void initialize(final Profile profile) throws InitializationException {
        WebServerPreferences preferences = InstanceManager.getDefault(WebServerPreferences.class);
        preferences.addPropertyChangeListener("allowRemoteConfig", evt -> this.savePreferences(profile));
        preferences.addPropertyChangeListener("railroadName", evt -> this.savePreferences(profile));
        preferences.addPropertyChangeListener("readonlyPower", evt -> this.savePreferences(profile));
        WebServer.getDefault().addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarting(LifeCycle lc) {
                WebAppManager.this.lifeCycleStarting(lc, profile);
            }

            public void lifeCycleStarted(LifeCycle lc) {
                WebAppManager.this.lifeCycleStarted(lc, profile);
            }

            public void lifeCycleFailure(LifeCycle lc, Throwable thrwbl) {
                WebAppManager.this.lifeCycleFailure(lc, thrwbl, profile);
            }

            public void lifeCycleStopping(LifeCycle lc) {
                WebAppManager.this.lifeCycleStopping(lc, profile);
            }

            public void lifeCycleStopped(LifeCycle lc) {
                WebAppManager.this.lifeCycleStopped(lc, profile);
            }
        });
        if (WebServer.getDefault().isRunning()) {
            this.lifeCycleStarting(null, profile);
            this.lifeCycleStarted(null, profile);
        }
        this.setInitialized(profile, true);
    }

    @Override
    public void savePreferences(Profile profile) {
        File cache = ProfileUtils.getCacheDirectory(profile, this.getClass());
        FileUtil.delete(cache);
        ((List)this.manifests.getOrDefault(profile, new ArrayList())).clear();
    }

    private List<WebManifest> getManifests(Profile profile) {
        if (!this.manifests.containsKey(profile)) {
            this.manifests.put(profile, new ArrayList());
        }
        if (this.manifests.get(profile).isEmpty()) {
            ServiceLoader.load(WebManifest.class).forEach(manifest -> this.manifests.get(profile).add((WebManifest)manifest));
        }
        return this.manifests.get(profile);
    }

    public String getScriptTags(Profile profile) {
        StringBuilder tags = new StringBuilder();
        ArrayList scripts = new ArrayList();
        this.getManifests(profile).forEach(manifest -> manifest.getScripts().stream().filter(script -> !scripts.contains(script)).forEachOrdered(script -> scripts.add(script)));
        scripts.forEach(script -> tags.append("<script src=\"").append((String)script).append("\"></script>\n"));
        return tags.toString();
    }

    public String getStyleTags(Profile profile) {
        StringBuilder tags = new StringBuilder();
        ArrayList styles = new ArrayList();
        this.getManifests(profile).forEach(manifest -> manifest.getStyles().stream().filter(style -> !styles.contains(style)).forEachOrdered(style -> styles.add(style)));
        styles.forEach(style -> tags.append("<link rel=\"stylesheet\" href=\"").append((String)style).append("\" type=\"text/css\">\n"));
        return tags.toString();
    }

    public String getNavigation(Profile profile, Locale locale) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode navigation = mapper.createArrayNode();
        ArrayList items = new ArrayList();
        this.getManifests(profile).forEach(manifest -> manifest.getNavigationMenuItems().stream().filter(item -> !item.getPath().startsWith("help") && !item.getPath().startsWith("user") && !items.contains(item)).forEachOrdered(item -> items.add(item)));
        items.sort((o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
        for (int i = 0; i < items.size(); ++i) {
            WebMenuItem item = (WebMenuItem)items.get(i);
            ObjectNode navItem = this.getMenuItem(item, mapper, locale);
            ArrayNode children = mapper.createArrayNode();
            for (int j = i + 1; j < items.size() && ((WebMenuItem)items.get(j)).getPath().startsWith(item.getPath()); ++j) {
                ObjectNode child = this.getMenuItem((WebMenuItem)items.get(j), mapper, locale);
                if (((WebMenuItem)items.get(j)).getHref() != null) {
                    children.add((JsonNode)child);
                }
                ++i;
            }
            navItem.set("children", (JsonNode)children);
            if (item.getHref() == null && children.size() == 0) continue;
            navigation.add((JsonNode)navItem);
        }
        return mapper.writeValueAsString((Object)navigation);
    }

    public String getHelpMenuItems(Profile profile, Locale locale) {
        return this.getMenuItems("help", profile, locale);
    }

    public String getUserMenuItems(Profile profile, Locale locale) {
        return this.getMenuItems("user", profile, locale);
    }

    private String getMenuItems(String menu, Profile profile, Locale locale) {
        StringBuilder navigation = new StringBuilder();
        ArrayList items = new ArrayList();
        this.getManifests(profile).forEach(manifest -> manifest.getNavigationMenuItems().stream().filter(item -> item.getPath().startsWith(menu) && !items.contains(item)).forEachOrdered(item -> items.add(item)));
        items.sort((o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
        items.forEach(item -> {
            String href = item.getHref();
            String title = item.getTitle(locale);
            if (title.startsWith("translate:")) {
                title = String.format("<span data-translate>%s</span>", title.substring(10));
            }
            if (href != null && href.startsWith("ng-click:")) {
                navigation.append(String.format("<li><a ng-click=\"%s\">%s</a></li>", href.substring(href.indexOf(":") + 1, href.length()), title));
            } else {
                navigation.append(String.format("<li><a href=\"%s\">%s</a></li>", href, title));
            }
        });
        return navigation.toString();
    }

    private ObjectNode getMenuItem(WebMenuItem item, ObjectMapper mapper, Locale locale) {
        ObjectNode navItem = mapper.createObjectNode();
        navItem.put("title", item.getTitle(locale));
        if (item.getIconClass() != null) {
            navItem.put("iconClass", item.getIconClass());
        }
        if (item.getHref() != null) {
            navItem.put("href", item.getHref());
        }
        return navItem;
    }

    public String getAngularDependencies(Profile profile, Locale locale) {
        StringJoiner dependencies = new StringJoiner("',\n  '", "\n  '", "'");
        ArrayList items = new ArrayList();
        this.getManifests(profile).forEach(manifest -> manifest.getAngularDependencies().stream().filter(dependency -> !items.contains(dependency)).forEachOrdered(dependency -> items.add(dependency)));
        items.forEach(dependency -> dependencies.add((CharSequence)dependency));
        return dependencies.toString();
    }

    public String getAngularRoutes(Profile profile, Locale locale) {
        StringJoiner routes = new StringJoiner("\n", "\n", "");
        HashSet items = new HashSet();
        this.getManifests(profile).forEach(manifest -> items.addAll(manifest.getAngularRoutes()));
        items.forEach(route -> {
            if (route.getRedirection() != null) {
                routes.add(String.format("      .when('%s', { redirectTo: '%s' })", route.getWhen(), route.getRedirection()));
            } else if (route.getTemplate() != null && route.getController() != null) {
                routes.add(String.format("      .when('%s', { templateUrl: '%s', controller: '%s' })", route.getWhen(), route.getTemplate(), route.getController()));
            }
        });
        return routes.toString();
    }

    public String getAngularSources(Profile profile, Locale locale) {
        StringJoiner sources = new StringJoiner("\n", "\n\n", "\n");
        ArrayList urls = new ArrayList();
        this.getManifests(profile).forEach(manifest -> urls.addAll(manifest.getAngularSources()));
        urls.forEach(source -> {
            try {
                sources.add(FileUtil.readURL(source));
            }
            catch (IOException ex) {
                log.error("Unable to read {}", source, (Object)ex);
            }
        });
        return sources.toString();
    }

    public Set<URI> getPreloadedTranslations(Profile profile, Locale locale) {
        HashSet<URI> urls = new HashSet<URI>();
        this.getManifests(profile).forEach(manifest -> urls.addAll(manifest.getPreloadedTranslations(locale)));
        return urls;
    }

    private void lifeCycleStarting(LifeCycle lc, Profile profile) {
        if (this.watcher.get(profile) == null) {
            try {
                this.watcher.put(profile, FileSystems.getDefault().newWatchService());
            }
            catch (IOException ex) {
                log.warn("Unable to watch file system for changes.");
            }
        }
    }

    private void lifeCycleStarted(LifeCycle lc, Profile profile) {
        if (this.watcher.get(profile) != null) {
            FileUtil.findFiles("web", ".").stream().filter(file -> file.isDirectory()).forEachOrdered(file -> {
                try {
                    Path path = file.toPath();
                    this.watchPaths.put(path.register(this.watcher.get(profile), StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), path);
                }
                catch (IOException ex) {
                    log.error("Unable to watch {} for changes.", file);
                }
                this.lifeCycleListener = new Thread(() -> {
                    while (this.watcher.get(profile) != null) {
                        WatchKey key;
                        try {
                            key = this.watcher.get(profile).take();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        key.pollEvents().stream().filter(event -> event.kind() != StandardWatchEventKinds.OVERFLOW).forEachOrdered(event -> this.savePreferences(profile));
                        if (key.reset()) continue;
                        this.watcher.remove(profile);
                    }
                }, "WebAppManager");
                this.lifeCycleListener.start();
            });
        }
    }

    private void lifeCycleFailure(LifeCycle lc, Throwable thrwbl, Profile profile) {
        log.debug("Web server life cycle failure", thrwbl);
        this.lifeCycleStopped(lc, profile);
    }

    private void lifeCycleStopping(LifeCycle lc, Profile profile) {
        this.lifeCycleStopped(lc, profile);
    }

    private void lifeCycleStopped(LifeCycle lc, Profile profile) {
        if (this.lifeCycleListener != null) {
            this.lifeCycleListener.interrupt();
            this.lifeCycleListener = null;
        }
        this.watcher.remove(profile);
    }
}

