/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.web.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.server.web.app.Bundle;
import jmri.server.web.app.WebAppManager;
import jmri.util.FileUtil;
import jmri.web.server.WebServerPreferences;
import jmri.web.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="AppDynamicServlet", urlPatterns={"/app", "/app/script", "/app/about"})
public class WebAppServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(WebAppServlet.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("App contextPath: {}, pathInfo: {}", (Object)request.getContextPath(), (Object)request.getPathInfo());
        response.setHeader("Connection", "Keep-Alive");
        switch (request.getContextPath()) {
            case "/app": {
                if (request.getPathInfo().startsWith("/locale-")) {
                    this.processLocale(request, response);
                    break;
                }
                this.processApp(request, response);
                break;
            }
            case "/app/about": {
                this.processAbout(request, response);
                break;
            }
            case "/app/script": {
                this.processScript(request, response);
                break;
            }
        }
    }

    private void processApp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=utf-8");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        File cache = new File(ProfileUtils.getCacheDirectory(profile, ((Object)((Object)this)).getClass()), request.getLocale().toString());
        FileUtil.createDirectory(cache);
        File index = new File(cache, "index.html");
        if (!index.exists()) {
            String inComments = "-->%n%s<!--";
            WebAppManager manager = this.getWebAppManager();
            FileUtil.appendTextToFile(index, String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL("web/app/app/index.html")), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), String.format(inComments, manager.getScriptTags(profile)), String.format(inComments, manager.getStyleTags(profile)), "<!-- -->", String.format(inComments, manager.getHelpMenuItems(profile, request.getLocale())), String.format(inComments, manager.getUserMenuItems(profile, request.getLocale()))));
        }
        response.getWriter().print(FileUtil.readFile(index));
    }

    private void processAbout(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json; charset=utf-8");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode about = mapper.createObjectNode();
        about.put("additionalInfo", Bundle.getMessage(request.getLocale(), "AdditionalInfo", Application.getApplicationName()));
        about.put("copyright", Version.getCopyright());
        about.put("title", InstanceManager.getDefault(WebServerPreferences.class).getRailroadName());
        about.put("imgAlt", Application.getApplicationName());
        about.put("imgSrc", "/" + Application.getLogo());
        ArrayNode productInfo = about.putArray("productInfo");
        productInfo.add((JsonNode)mapper.createObjectNode().put("name", Application.getApplicationName()).put("value", Version.name()));
        if (profile != null) {
            productInfo.add((JsonNode)mapper.createObjectNode().put("name", Bundle.getMessage(request.getLocale(), "ActiveProfile")).put("value", profile.getName()));
        }
        productInfo.add((JsonNode)mapper.createObjectNode().put("name", "Java").put("value", Bundle.getMessage(request.getLocale(), "JavaVersion", System.getProperty("java.version", Bundle.getMessage(request.getLocale(), "Unknown")), System.getProperty("java.vm.name", Bundle.getMessage(request.getLocale(), "Unknown")), System.getProperty("java.vm.version", ""), System.getProperty("java.vendor", Bundle.getMessage(request.getLocale(), "Unknown")))));
        productInfo.add((JsonNode)mapper.createObjectNode().put("name", Bundle.getMessage(request.getLocale(), "Runtime")).put("value", Bundle.getMessage(request.getLocale(), "RuntimeVersion", System.getProperty("java.runtime.name", Bundle.getMessage(request.getLocale(), "Unknown")), System.getProperty("java.runtime.version", ""))));
        for (ConnectionConfig conn : InstanceManager.getDefault(ConnectionConfigManager.class)) {
            if (conn.getDisabled()) continue;
            productInfo.add((JsonNode)mapper.createObjectNode().put("name", Bundle.getMessage(request.getLocale(), "ConnectionName", conn.getConnectionName())).put("value", Bundle.getMessage(request.getLocale(), "ConnectionValue", conn.name(), conn.getInfo())));
        }
        response.getWriter().print(mapper.writeValueAsString((Object)about));
    }

    private void processScript(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/javascript; charset=utf-8");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        File cache = new File(ProfileUtils.getCacheDirectory(profile, ((Object)((Object)this)).getClass()), request.getLocale().toString());
        FileUtil.createDirectory(cache);
        File script = new File(cache, "script.js");
        if (!script.exists()) {
            WebAppManager manager = this.getWebAppManager();
            FileUtil.appendTextToFile(script, String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL("web/app/app/script.js")), manager.getAngularDependencies(profile, request.getLocale()), manager.getAngularRoutes(profile, request.getLocale()), String.format("%n    $scope.navigationItems = %s;%n", manager.getNavigation(profile, request.getLocale())), manager.getAngularSources(profile, request.getLocale()), InstanceManager.getDefault(WebServerPreferences.class).getRailroadName()));
        }
        response.getWriter().print(FileUtil.readFile(script));
    }

    private void processLocale(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json; charset=utf-8");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        Locale locale = new Locale(request.getPathInfo().substring(8, request.getPathInfo().length() - 5));
        File cache = new File(ProfileUtils.getCacheDirectory(profile, ((Object)((Object)this)).getClass()), locale.toString());
        FileUtil.createDirectory(cache);
        File file = new File(cache, "locale.json");
        if (!file.exists()) {
            WebAppManager manager = this.getWebAppManager();
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode translation = mapper.createObjectNode();
            for (URI url : manager.getPreloadedTranslations(profile, locale)) {
                log.debug("Reading {}", (Object)url);
                JsonNode translations = mapper.readTree(url.toURL());
                log.debug("Read {}", (Object)translations);
                if (!translations.isObject()) continue;
                log.debug("Adding {}", (Object)translations);
                Iterator fields = translations.fields();
                fields.forEachRemaining(field -> translation.set((String)field.getKey(), (JsonNode)field.getValue()));
            }
            log.debug("Writing {}", (Object)translation);
            mapper.writeValue(file, (Object)translation);
        }
        response.getWriter().print(FileUtil.readFile(file));
    }

    private WebAppManager getWebAppManager() throws ServletException {
        return InstanceManager.getOptionalDefault(WebAppManager.class).orElseThrow(ServletException::new);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "JMRI Web App support";
    }
}

