/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class JTitledSeparator
extends JPanel {
    private final JLabel label = new JLabel();

    public JTitledSeparator(String title) {
        super(new BorderLayout());
        JPanel westPanel = new JPanel(new BorderLayout()){

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                this.doLayout();
            }
        };
        westPanel.setOpaque(false);
        westPanel.setDoubleBuffered(false);
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        this.setOpaque(false);
        westPanel.add((Component)this.label, "Center");
        if (isLeftToRight) {
            this.add((Component)westPanel, "West");
        } else {
            this.add((Component)westPanel, "East");
        }
        SeparatorPane separatorPane = new SeparatorPane();
        if (isLeftToRight) {
            separatorPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        } else {
            separatorPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        }
        this.add((Component)separatorPane, "Center");
        this.setTitle(title);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
        this.adjustLook();
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        boolean isVisible = title.length() != 0;
        this.label.setVisible(isVisible);
        this.label.setText(title);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustLook();
    }

    private void adjustLook() {
        if (this.label != null) {
            Color titleColor = UIManager.getColor("TitledBorder.titleColor");
            Font font = UIManager.getFont("TitledBorder.font");
            if (titleColor == null || font == null) {
                TitledBorder titledBorder = new TitledBorder("");
                titleColor = titledBorder.getTitleColor();
                font = titledBorder.getTitleFont();
            }
            this.label.setForeground(titleColor);
            this.label.setFont(font);
        }
    }

    private static final class SeparatorPane
    extends JPanel {
        private SeparatorPane() {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.add((Component)new JSeparator(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.doLayout();
        }
    }
}

