/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProxyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerComboBox<B extends NamedBean>
extends JComboBox<Manager<B>> {
    private static final Logger log = LoggerFactory.getLogger(ManagerComboBox.class);

    public ManagerComboBox() {
        this(new ArrayList<Manager<B>>());
    }

    public ManagerComboBox(@Nonnull List<Manager<B>> list) {
        this(list, null);
    }

    public ManagerComboBox(@Nonnull List<Manager<B>> list, Manager<B> selection) {
        this.setRenderer(new ManagerRenderer(this.getRenderer()));
        this.setManagers(list, selection);
    }

    public void setManagers(@Nonnull List<Manager<B>> list) {
        this.setManagers(list, null);
    }

    public void setManagers(@Nonnull List<Manager<B>> list, Manager<B> selection) {
        this.setModel(new DefaultComboBoxModel<Manager<B>>(new Vector<Manager<B>>(list)));
        if (!list.isEmpty()) {
            if (selection == null) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedItem(selection);
            }
        }
    }

    public void setManagers(@Nonnull Manager<B> manager) {
        if (manager instanceof ProxyManager) {
            ProxyManager proxy = (ProxyManager)manager;
            for (Manager item : proxy.getDisplayOrderManagerList()) {
                log.trace("adding {} to manager combobox", item);
            }
            log.trace("Setting {} selected", proxy.getDefaultManager());
            this.setManagers(proxy.getDisplayOrderManagerList(), proxy.getDefaultManager());
            log.trace("{} is selected", this.getSelectedItem());
        } else {
            ArrayList<Manager<B>> list = new ArrayList<Manager<B>>();
            list.add(manager);
            this.setManagers(list, manager);
        }
    }

    @Override
    public Manager<B> getSelectedItem() {
        return (Manager)this.getItemAt(this.getSelectedIndex());
    }

    private class ManagerRenderer
    implements ListCellRenderer<Manager<B>> {
        private final ListCellRenderer<? super Manager<B>> myRenderer;

        public ManagerRenderer(ListCellRenderer<? super Manager<B>> renderer) {
            this.myRenderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Manager<B>> list, Manager<B> value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.myRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                label.setText(value.getMemo().getUserName());
            }
            return label;
        }
    }
}

