/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jmri.BooleanPermission;
import jmri.Permission;
import jmri.PermissionValue;
import jmri.Role;

public interface PermissionSwing {
    default public JLabel getLabel(Permission permission) throws IllegalArgumentException {
        return null;
    }

    public JComponent getComponent(Role var1, Permission var2, Runnable var3) throws IllegalArgumentException;

    public static abstract class BooleanPermissionSwing
    implements PermissionSwing {
        @Override
        public JComponent getComponent(Role role, Permission permission, Runnable onChange) throws IllegalArgumentException {
            JCheckBox checkBox = new JCheckBox(permission.getName());
            PermissionValue value = role.getPermissionValue(permission);
            if (!(value instanceof BooleanPermission.BooleanValue)) {
                throw new IllegalArgumentException("Permission value is not a BooleanValue: " + value.getClass().getName());
            }
            checkBox.setSelected(((BooleanPermission.BooleanValue)value).get());
            checkBox.addActionListener(evt -> {
                role.setPermission(permission, BooleanPermission.BooleanValue.get(checkBox.isSelected()));
                onChange.run();
            });
            return checkBox;
        }
    }
}

