/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.lang.reflect.InvocationTargetException;
import jmri.Permission;
import jmri.swing.PermissionSwing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionSwingTools {
    private static final Logger log = LoggerFactory.getLogger(PermissionSwingTools.class);

    private PermissionSwingTools() {
    }

    public static String adapterNameForObject(Object o) {
        return PermissionSwingTools.adapterNameForClass(o.getClass());
    }

    public static String adapterNameForClass(Class<?> c) {
        String className = c.getName();
        log.trace("handle object of class {}", (Object)className);
        int lastDot = className.lastIndexOf(".");
        if (lastDot > 0) {
            int firstDollarSign = className.indexOf("$");
            String result = firstDollarSign > 0 ? className.substring(0, lastDot) + ".swing." + className.substring(lastDot + 1, firstDollarSign) + "Swing$" + className.substring(firstDollarSign + 1) + "Swing" : className.substring(0, lastDot) + ".swing." + className.substring(lastDot + 1, className.length()) + "Swing";
            log.trace("adapter class name is {}", (Object)result);
            return result;
        }
        log.error("No package name found, which is not yet handled!");
        throw new RuntimeException("No package name found, which is not yet handled!");
    }

    public static PermissionSwing getPermissionSwingForClass(Permission permission) {
        PermissionSwing permissionSwing;
        Class<?> clazz = permission.getClass();
        try {
            permissionSwing = (PermissionSwing)Class.forName(PermissionSwingTools.adapterNameForClass(clazz)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Cannot load PermissionSwing for {}", (Object)clazz.getName(), (Object)ex);
            return null;
        }
        return permissionSwing;
    }
}

