/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.swing.Bundle;

public abstract class PowerManagerMenu
extends JMenu {
    JMenuItem allConnsItem = new JRadioButtonMenuItem(Bundle.getMessage("AllConnections"));
    private final List<JMenuItem> menuItems = new ArrayList<JMenuItem>();

    protected abstract void choiceChanged();

    public PowerManagerMenu() {
        this(false, null);
    }

    public PowerManagerMenu(boolean includeAllConns, PowerManager defaultPwrMgr) {
        ButtonGroup group = new ButtonGroup();
        this.setText(Bundle.getMessage("MenuConnection"));
        if (includeAllConns) {
            this.add(this.allConnsItem);
            group.add(this.allConnsItem);
            this.menuItems.add(this.allConnsItem);
            this.allConnsItem.addActionListener(e -> this.choiceChanged());
        }
        List<PowerManager> managers = InstanceManager.getList(PowerManager.class);
        for (PowerManager mgr : managers) {
            if (mgr == null) continue;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(PowerManagerMenu.getManagerNameIncludeIfDefault(mgr));
            item.setActionCommand(mgr.getUserName());
            this.add(item);
            group.add(item);
            this.menuItems.add(item);
            item.addActionListener(e -> this.choiceChanged());
        }
        this.setManager(defaultPwrMgr);
    }

    public void setManager(@CheckForNull PowerManager suppliedMgr) {
        if (InstanceManager.getNullableDefault(PowerManager.class) == null) {
            return;
        }
        String searchMgr = suppliedMgr != null ? suppliedMgr.getUserName() : "";
        for (JMenuItem item : this.menuItems) {
            if (!searchMgr.equals(item.getActionCommand())) continue;
            item.setSelected(true);
            return;
        }
        this.allConnsItem.setSelected(true);
    }

    @CheckForNull
    public PowerManager getManager() {
        List<PowerManager> managers;
        String name = "";
        for (JMenuItem item : this.menuItems) {
            if (!item.isSelected()) continue;
            name = item.getActionCommand();
            break;
        }
        if ((managers = InstanceManager.getList(PowerManager.class)).size() == 1) {
            return managers.get(0);
        }
        for (PowerManager mgr : managers) {
            if (!name.equals(mgr.getUserName())) continue;
            return mgr;
        }
        return null;
    }

    @Nonnull
    public static String getManagerNameIncludeIfDefault(@Nonnull PowerManager mgr) {
        String mgrName = mgr.getUserName();
        if (mgr == InstanceManager.getDefault(PowerManager.class)) {
            mgrName = Bundle.getMessage("DefaultConnection", mgr.getUserName());
        }
        return mgrName;
    }
}

